/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.XPackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.core.io.FileSpanningInputStream;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class MultiVolumeFileUnpacker
extends FileUnpacker {
    private final FileSpanningInputStream volumes;
    private static final Logger logger = Logger.getLogger(MultiVolumeFileUnpacker.class.getName());

    public MultiVolumeFileUnpacker(FileSpanningInputStream volumes, Cancellable cancellable, FileQueue queue) {
        super(cancellable, queue);
        this.volumes = volumes;
    }

    @Override
    public void unpack(PackFile packFile, InputStream packInputStream, File target) throws IOException, InstallerException {
        long position = ((XPackFile)packFile).getArchiveFilePosition();
        long filePointer = this.volumes.getFilePointer();
        if (filePointer < position) {
            logger.fine("Skipping bytes to get to file " + target.getName() + " (" + filePointer + "<" + position + ") target is: " + (position - filePointer));
            this.skip(position - filePointer);
        }
        if (this.volumes.getFilePointer() > position) {
            throw new IOException("Error, can't access file in pack.");
        }
        this.copy(packFile, (InputStream)this.volumes, target);
    }

    protected void skip(long bytes) throws IOException {
        long skipped = this.volumes.skip(bytes);
        if (skipped != bytes) {
            throw new IOException("Expected to skip: " + bytes + " in stream but skipped: " + skipped);
        }
    }
}

