/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.installer.container.impl.GUIInstallerContainer;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.InstallData;
import com.izforge.izpack.installer.gui.InstallerController;
import com.izforge.izpack.installer.gui.SplashScreen;
import com.izforge.izpack.installer.language.LanguageDialog;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class InstallerGui {
    private static final Logger logger = Logger.getLogger(InstallerGui.class.getName());
    private static SplashScreen splashScreen = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(final String langCode, String mediaPath, Overrides defaults) throws Exception {
        GUIInstallerContainer applicationComponent = new GUIInstallerContainer();
        final Container installerContainer = (Container)applicationComponent.getComponent(Container.class);
        final Object trigger = new Object();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    splashScreen = (SplashScreen)installerContainer.getComponent(SplashScreen.class);
                    splashScreen.displaySplashScreen(trigger);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Prepare and display splashScreen failed.", e);
                    throw new IzPackException((Throwable)e);
                }
            }
        });
        try {
            int duration;
            GUIInstallData installData = (GUIInstallData)applicationComponent.getComponent(GUIInstallData.class);
            if (mediaPath != null) {
                installData.setMediaPath(mediaPath);
            }
            if (defaults != null) {
                defaults.setInstallData((com.izforge.izpack.api.data.InstallData)applicationComponent.getComponent(InstallData.class));
                defaults.load();
                logger.info("Loaded " + defaults.size() + " override(s) from " + defaults.getFile());
                DefaultVariables variables = (DefaultVariables)applicationComponent.getComponent(DefaultVariables.class);
                variables.setOverrides(defaults);
            }
            InstallerController controller = (InstallerController)installerContainer.getComponent(InstallerController.class);
            if (installData.guiPrefs.modifier.containsKey("useSplashScreen") && (duration = Integer.parseInt((String)installData.guiPrefs.modifier.get("useSplashScreen"))) > 0) {
                Object object = trigger;
                synchronized (object) {
                    trigger.wait(duration);
                }
            }
            if (splashScreen != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            splashScreen.removeSplashScreen();
                        }
                        catch (Exception e) {
                            throw new IzPackException((Throwable)e);
                        }
                    }
                });
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (langCode == null) {
                        try {
                            ((LanguageDialog)installerContainer.getComponent(LanguageDialog.class)).initLangPack();
                        }
                        catch (Exception ex) {
                            logger.severe("The language pack couldn't be initialized.");
                        }
                    } else {
                        ((LanguageDialog)installerContainer.getComponent(LanguageDialog.class)).propagateLocale(langCode);
                    }
                    if (!((RequirementsChecker)installerContainer.getComponent(RequirementsChecker.class)).check()) {
                        logger.info("Not all installer requirements are fulfilled.");
                        ((Housekeeper)installerContainer.getComponent(Housekeeper.class)).shutDown(-1);
                    }
                }
            });
            controller.buildInstallation().launchInstallation();
        }
        catch (Exception e) {
            throw new IzPackException((Throwable)e);
        }
    }
}

