/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.javac;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.ResolveVisitor;

public class JavaStubGenerator {
    private boolean java5 = false;
    private boolean requireSuperResolved = false;
    private File outputPath;
    private List toCompile = new ArrayList();

    public JavaStubGenerator(File outputPath, boolean requireSuperResolved, boolean java5) {
        this.outputPath = outputPath;
        this.requireSuperResolved = requireSuperResolved;
        this.java5 = java5;
    }

    public JavaStubGenerator(File outputPath) {
        this(outputPath, false, false);
    }

    private void mkdirs(File parent, String relativeFile) {
        int index = relativeFile.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        File dir = new File(parent, relativeFile.substring(0, index));
        dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClass(ClassNode classNode) throws FileNotFoundException {
        if (this.requireSuperResolved && !classNode.getSuperClass().isResolved()) {
            return;
        }
        String fileName = classNode.getName().replace('.', '/');
        this.mkdirs(this.outputPath, fileName);
        this.toCompile.add(fileName);
        File file = new File(this.outputPath, fileName + ".java");
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter out = new PrintWriter(fos);
        try {
            ClassNode[] interfaces;
            String packageName = classNode.getPackageName();
            if (packageName != null) {
                out.println("package " + packageName + ";\n");
            }
            this.genImports(classNode, out);
            boolean isInterface = classNode.isInterface();
            boolean isEnum = (classNode.getModifiers() & 0x4000) != 0;
            this.printModifiers(out, classNode.getModifiers() & ~(isInterface ? 1024 : 0));
            if (isInterface) {
                out.print("interface ");
            } else if (isEnum) {
                out.print("enum ");
            } else {
                out.print("class ");
            }
            out.println(classNode.getNameWithoutPackage());
            this.writeGenericsBounds(out, classNode, true);
            ClassNode superClass = classNode.getUnresolvedSuperClass(false);
            if (!isInterface) {
                if (superClass.equals(ClassHelper.OBJECT_TYPE)) {
                    superClass = ClassHelper.make(GroovyObjectSupport.class);
                }
                if (!isEnum) {
                    out.print("  extends ");
                    this.printType(superClass, out);
                }
            }
            if ((interfaces = classNode.getInterfaces()) != null && interfaces.length > 0) {
                if (isInterface) {
                    out.println("  extends");
                } else {
                    out.println("  implements");
                }
                for (int i = 0; i < interfaces.length - 1; ++i) {
                    out.print("    ");
                    this.printType(interfaces[i], out);
                    out.print(",");
                }
                out.print("    ");
                this.printType(interfaces[interfaces.length - 1], out);
            }
            out.println(" {");
            this.genFields(classNode, out, isEnum);
            this.genMethods(classNode, out, isEnum);
            this.genProps(classNode, out);
            out.println("}");
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {}
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    private void genMethods(ClassNode classNode, PrintWriter out, boolean isEnum) {
        List methods;
        if (!isEnum) {
            this.getConstructors(classNode, out);
        }
        if ((methods = classNode.getMethods()) != null) {
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                MethodNode methodNode = (MethodNode)it.next();
                if (isEnum && methodNode.isSynthetic()) {
                    String name = methodNode.getName();
                    Parameter[] params = methodNode.getParameters();
                    if (name.equals("values") && params.length == 0 || name.equals("valueOf") && params.length == 1 && params[0].getType().equals(ClassHelper.STRING_TYPE)) continue;
                }
                this.genMethod(classNode, methodNode, out);
            }
        }
    }

    private void getConstructors(ClassNode classNode, PrintWriter out) {
        List constrs = classNode.getDeclaredConstructors();
        if (constrs != null) {
            Iterator it = constrs.iterator();
            while (it.hasNext()) {
                ConstructorNode constrNode = (ConstructorNode)it.next();
                this.genConstructor(classNode, constrNode, out);
            }
        }
    }

    private void genFields(ClassNode classNode, PrintWriter out, boolean isEnum) {
        FieldNode fieldNode;
        List fields = classNode.getFields();
        if (fields == null) {
            return;
        }
        ArrayList<FieldNode> enumFields = new ArrayList<FieldNode>(fields.size());
        ArrayList<FieldNode> normalFields = new ArrayList<FieldNode>(fields.size());
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            boolean isSynthetic;
            fieldNode = (FieldNode)it.next();
            boolean isEnumField = (fieldNode.getModifiers() & 0x4000) != 0;
            boolean bl = isSynthetic = (fieldNode.getModifiers() & 0x1000) != 0;
            if (isEnumField) {
                enumFields.add(fieldNode);
                continue;
            }
            if (isSynthetic) continue;
            normalFields.add(fieldNode);
        }
        this.genEnumFields(enumFields, out);
        Iterator iterator = normalFields.iterator();
        while (iterator.hasNext()) {
            fieldNode = (FieldNode)iterator.next();
            this.genField(fieldNode, out);
        }
    }

    private void genProps(ClassNode classNode, PrintWriter out) {
        List props = classNode.getProperties();
        if (props != null) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                PropertyNode propNode = (PropertyNode)it.next();
                this.genProp(propNode, out);
            }
        }
    }

    private void genProp(PropertyNode propNode, PrintWriter out) {
        String name = propNode.getName().substring(0, 1).toUpperCase() + propNode.getName().substring(1);
        String getterName = "get" + name;
        boolean skipGetter = false;
        List getterCandidates = propNode.getField().getOwner().getMethods(getterName);
        if (getterCandidates != null) {
            Iterator it = getterCandidates.iterator();
            while (it.hasNext()) {
                MethodNode method = (MethodNode)it.next();
                if (method.getParameters().length != 0) continue;
                skipGetter = true;
            }
        }
        if (!skipGetter) {
            this.printModifiers(out, propNode.getModifiers());
            this.printType(propNode.getType(), out);
            out.print(" ");
            out.print(getterName);
            out.print("() { ");
            this.printReturn(out, propNode.getType());
            out.println(" }");
        }
        String setterName = "set" + name;
        boolean skipSetter = false;
        List setterCandidates = propNode.getField().getOwner().getMethods(setterName);
        if (setterCandidates != null) {
            Iterator it = setterCandidates.iterator();
            while (it.hasNext()) {
                MethodNode method = (MethodNode)it.next();
                if (method.getParameters().length != 1) continue;
                skipSetter = true;
            }
        }
        if (!skipSetter) {
            this.printModifiers(out, propNode.getModifiers());
            out.print("void ");
            out.print(setterName);
            out.print("(");
            this.printType(propNode.getType(), out);
            out.println(" value) {}");
        }
    }

    private void genEnumFields(List fields, PrintWriter out) {
        if (fields.size() == 0) {
            return;
        }
        boolean first = true;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            FieldNode fieldNode = (FieldNode)iterator.next();
            if (!first) {
                out.print(", ");
            } else {
                first = false;
            }
            out.print(fieldNode.getName());
        }
        out.println(";");
    }

    private void genField(FieldNode fieldNode, PrintWriter out) {
        if ((fieldNode.getModifiers() & 2) != 0) {
            return;
        }
        this.printModifiers(out, fieldNode.getModifiers());
        this.printType(fieldNode.getType(), out);
        out.print(" ");
        out.print(fieldNode.getName());
        out.println(";");
    }

    private ConstructorCallExpression getConstructorCallExpression(ConstructorNode constructorNode) {
        Statement code = constructorNode.getCode();
        if (!(code instanceof BlockStatement)) {
            return null;
        }
        BlockStatement block = (BlockStatement)code;
        List stats = block.getStatements();
        if (stats == null || stats.size() == 0) {
            return null;
        }
        Statement stat = (Statement)stats.get(0);
        if (!(stat instanceof ExpressionStatement)) {
            return null;
        }
        Expression expr = ((ExpressionStatement)stat).getExpression();
        if (!(expr instanceof ConstructorCallExpression)) {
            return null;
        }
        return (ConstructorCallExpression)expr;
    }

    private void genConstructor(ClassNode clazz, ConstructorNode constructorNode, PrintWriter out) {
        out.print("public ");
        out.print(clazz.getNameWithoutPackage());
        this.printParams(constructorNode, out);
        ConstructorCallExpression constrCall = this.getConstructorCallExpression(constructorNode);
        if (constrCall == null || !constrCall.isSpecialCall()) {
            out.println(" {}");
        } else {
            out.println(" {");
            this.genSpecialConstructorArgs(out, constructorNode, constrCall);
            out.println("}");
        }
        Parameter[] params = this.getDefaultValueReducedParameters(constructorNode);
        if (params != constructorNode.getParameters()) {
            ConstructorNode m = new ConstructorNode(constructorNode.getModifiers(), params, constructorNode.getExceptions(), constructorNode.getCode());
            this.genConstructor(clazz, m, out);
        }
    }

    private ConstructorNode selectAccessibleConstructorFromSuper(ConstructorNode node) {
        ClassNode type = node.getDeclaringClass();
        ClassNode superType = type.getSuperClass();
        Iterator iter = superType.getDeclaredConstructors().iterator();
        while (iter.hasNext()) {
            ConstructorNode c = (ConstructorNode)iter.next();
            if (!c.isPublic() && !c.isProtected()) continue;
            return c;
        }
        if (!superType.isResolved()) {
            throw new Error("Super-class (" + superType.getName() + ")should have been resolved already for type: " + type.getName());
        }
        Constructor<?>[] constructors = superType.getTypeClass().getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            int mod = constructors[i].getModifiers();
            if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
            Class<?>[] types = constructors[i].getParameterTypes();
            Parameter[] params = new Parameter[types.length];
            for (int j = 0; j < types.length; ++j) {
                ClassNode ptype = ClassHelper.make(types[j]);
                params[j] = new Parameter(ptype, types[j].getName());
            }
            return new ConstructorNode(mod, params, null, null);
        }
        return null;
    }

    private void genSpecialConstructorArgs(PrintWriter out, ConstructorNode node, ConstructorCallExpression constrCall) {
        ConstructorNode c = this.selectAccessibleConstructorFromSuper(node);
        if (c != null) {
            out.print("super (");
            Parameter[] params = c.getParameters();
            for (int i = 0; i < params.length; ++i) {
                this.printDefaultValue(out, params[i].getType());
                if (i + 1 >= params.length) continue;
                out.print(", ");
            }
            out.println(");");
            return;
        }
        Expression arguments = constrCall.getArguments();
        if (constrCall.isSuperCall()) {
            out.print("super(");
        } else {
            out.print("this(");
        }
        if (arguments instanceof ArgumentListExpression) {
            ArgumentListExpression argumentListExpression = (ArgumentListExpression)arguments;
            List args = argumentListExpression.getExpressions();
            Iterator it = args.iterator();
            while (it.hasNext()) {
                Expression arg = (Expression)it.next();
                if (arg instanceof ConstantExpression) {
                    ConstantExpression expression = (ConstantExpression)arg;
                    Object o = expression.getValue();
                    if (o instanceof String) {
                        out.print("(String)null");
                    } else {
                        out.print(expression.getText());
                    }
                } else {
                    this.printDefaultValue(out, arg.getType());
                }
                if (arg == args.get(args.size() - 1)) continue;
                out.print(", ");
            }
        }
        out.println(");");
    }

    private void genMethod(ClassNode clazz, MethodNode methodNode, PrintWriter out) {
        if (methodNode.getName().equals("<clinit>")) {
            return;
        }
        if (!clazz.isInterface()) {
            this.printModifiers(out, methodNode.getModifiers());
        }
        this.printType(methodNode.getReturnType(), out);
        out.print(" ");
        out.print(methodNode.getName());
        this.printParams(methodNode, out);
        if ((methodNode.getModifiers() & 0x400) != 0) {
            out.println(";");
        } else {
            out.print(" { ");
            ClassNode retType = methodNode.getReturnType();
            this.printReturn(out, retType);
            out.println("}");
        }
        Parameter[] params = this.getDefaultValueReducedParameters(methodNode);
        if (params != methodNode.getParameters()) {
            MethodNode m = new MethodNode(methodNode.getName(), methodNode.getModifiers(), methodNode.getReturnType(), params, methodNode.getExceptions(), null);
            this.genMethod(clazz, m, out);
        }
    }

    private Parameter[] getDefaultValueReducedParameters(MethodNode methodNode) {
        Parameter[] params = methodNode.getParameters();
        for (int i = params.length - 1; i > -1; --i) {
            if (!params[i].hasInitialExpression()) continue;
            Parameter[] newParams = new Parameter[params.length - 1];
            System.arraycopy(params, 0, newParams, 0, i);
            System.arraycopy(params, i + 1, newParams, i, params.length - i - 1);
            return newParams;
        }
        return params;
    }

    private void printReturn(PrintWriter out, ClassNode retType) {
        String retName = retType.getName();
        if (!retName.equals("void")) {
            out.print("return ");
            this.printDefaultValue(out, retType);
            out.print(";");
        }
    }

    private void printDefaultValue(PrintWriter out, ClassNode type) {
        out.print("(");
        this.printType(type, out);
        out.print(")");
        if (ClassHelper.isPrimitiveType(type)) {
            if (type == ClassHelper.boolean_TYPE) {
                out.print("false");
            } else {
                out.print("0");
            }
        } else {
            out.print("null");
        }
    }

    private void printType(ClassNode type, PrintWriter out) {
        if (type.isArray()) {
            this.printType(type.getComponentType(), out);
            out.print("[]");
        } else {
            this.writeGenericsBounds(out, type, false);
        }
    }

    private void printTypeName(ClassNode type, PrintWriter out) {
        if (ClassHelper.isPrimitiveType(type)) {
            if (type == ClassHelper.boolean_TYPE) {
                out.print("boolean");
            } else if (type == ClassHelper.char_TYPE) {
                out.print("char");
            } else if (type == ClassHelper.int_TYPE) {
                out.print("int");
            } else if (type == ClassHelper.short_TYPE) {
                out.print("short");
            } else if (type == ClassHelper.long_TYPE) {
                out.print("long");
            } else if (type == ClassHelper.float_TYPE) {
                out.print("float");
            } else if (type == ClassHelper.double_TYPE) {
                out.print("double");
            } else if (type == ClassHelper.byte_TYPE) {
                out.print("byte");
            } else {
                out.print("void");
            }
        } else {
            out.print(type.redirect().getName().replace('$', '.'));
        }
    }

    private void writeGenericsBounds(PrintWriter out, ClassNode type, boolean skipName) {
        if (!skipName) {
            this.printTypeName(type, out);
        }
        if (this.java5 && !type.isGenericsPlaceHolder()) {
            this.writeGenericsBounds(out, type.getGenericsTypes());
        }
    }

    private void writeGenericsBounds(PrintWriter out, GenericsType[] genericsTypes) {
        if (genericsTypes == null || genericsTypes.length == 0) {
            return;
        }
        out.print('<');
        for (int i = 0; i < genericsTypes.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            this.writeGenericsBounds(out, genericsTypes[i]);
        }
        out.print('>');
    }

    private void writeGenericsBounds(PrintWriter out, GenericsType genericsType) {
        if (genericsType.isPlaceholder()) {
            out.print(genericsType.getName());
        } else {
            this.printTypeName(genericsType.getType(), out);
            ClassNode[] upperBounds = genericsType.getUpperBounds();
            ClassNode lowerBound = genericsType.getLowerBound();
            if (upperBounds != null) {
                out.print(" extends ");
                for (int i = 0; i < upperBounds.length; ++i) {
                    this.printType(upperBounds[i], out);
                    if (i + 1 >= upperBounds.length) continue;
                    out.print(" & ");
                }
            } else if (lowerBound != null) {
                out.print(" super ");
                this.printType(lowerBound, out);
            }
        }
    }

    private void printParams(MethodNode methodNode, PrintWriter out) {
        out.print("(");
        Parameter[] parameters = methodNode.getParameters();
        if (parameters != null && parameters.length != 0) {
            for (int i = 0; i != parameters.length; ++i) {
                this.printType(parameters[i].getType(), out);
                out.print(" ");
                out.print(parameters[i].getName());
                if (i + 1 >= parameters.length) continue;
                out.print(", ");
            }
        }
        out.print(")");
    }

    private void printModifiers(PrintWriter out, int modifiers) {
        if ((modifiers & 1) != 0) {
            out.print("public ");
        }
        if ((modifiers & 4) != 0) {
            out.print("protected ");
        }
        if ((modifiers & 2) != 0) {
            out.print("private ");
        }
        if ((modifiers & 8) != 0) {
            out.print("static ");
        }
        if ((modifiers & 0x20) != 0) {
            out.print("synchronized ");
        }
        if ((modifiers & 0x400) != 0) {
            out.print("abstract ");
        }
    }

    private void genImports(ClassNode classNode, PrintWriter out) {
        Object imp;
        HashSet<String> imports = new HashSet<String>();
        imports.addAll(Arrays.asList(ResolveVisitor.DEFAULT_IMPORTS));
        ModuleNode moduleNode = classNode.getModule();
        Iterator it = moduleNode.getImportPackages().iterator();
        while (it.hasNext()) {
            imports.add((String)it.next());
        }
        it = moduleNode.getImports().iterator();
        while (it.hasNext()) {
            imp = (ImportNode)it.next();
            String name = ((ImportNode)imp).getType().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) continue;
            imports.add(name.substring(0, lastDot + 1));
        }
        it = imports.iterator();
        while (it.hasNext()) {
            imp = (String)it.next();
            out.print("import ");
            out.print((String)imp);
            out.println("*;");
        }
        out.println();
    }

    public void clean() {
        Iterator it = this.toCompile.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            new File(this.outputPath, path + ".java").delete();
        }
    }
}

