/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class MetaFieldProperty
extends MetaProperty {
    boolean alreadySetAccessible;
    private Field field;

    public static MetaFieldProperty create(CachedField field) {
        return new MetaFieldProperty(field.field);
    }

    private MetaFieldProperty(Field field) {
        super(field.getName(), field.getType());
        this.field = field;
    }

    public Object getProperty(Object object) {
        if (!this.alreadySetAccessible) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MetaFieldProperty.this.field.setAccessible(true);
                    return null;
                }
            });
            this.alreadySetAccessible = true;
        }
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e);
        }
    }

    public void setProperty(Object object, Object newValue) {
        Object goalValue = DefaultTypeTransformation.castToType(newValue, this.field.getType());
        if (!this.alreadySetAccessible) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MetaFieldProperty.this.field.setAccessible(true);
                    return null;
                }
            });
            this.alreadySetAccessible = true;
        }
        try {
            this.field.set(object, goalValue);
        }
        catch (IllegalAccessException ex) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "'.", ex);
        }
    }

    private String toName(Class c) {
        String s = c.toString();
        if (s.startsWith("class ") && s.length() > 6) {
            return s.substring(6);
        }
        return s;
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }
}

