package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeHelper;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class ThesaurusAbstract extends BusinessEntityImpl implements Thesaurus {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionThesaurus;
    /**
     * getTags :
     * @return Set<String> 
     */

    @Override
    public Set<String> getTags() {
        Set<String> result = ThesaurusHelper.getTags(getWikitty());
        return result;
}

    /**
     * setTags :
     * @param tags 
     */

    @Override
    public void setTags(Set<String> tags) {
        Set<String> oldValue = getTags();
        ThesaurusHelper.setTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_TAGS, oldValue, getTags());
}

    /**
     * addAllTags :
     * @param tags 
     */

    @Override
    public void addAllTags(Set<String> tags) {
        Set<String> oldValue = getTags();
        ThesaurusHelper.addAllTags(getWikitty(), tags);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_TAGS, oldValue, getTags());
}

    /**
     * addTags :
     * @param element 
     */

    @Override
    public void addTags(String element) {
        ThesaurusHelper.addTags(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_TAGS, null, getTags());
}

    /**
     * removeTags :
     * @param element 
     */

    @Override
    public void removeTags(String element) {
        ThesaurusHelper.removeTags(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_TAGS, null, getTags());
}

    /**
     * clearTags :
     */

    @Override
    public void clearTags() {
        ThesaurusHelper.clearTags(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_TAGS, null, getTags());
}

    /**
     * getOrder :
     * @return int 
     */

    @Override
    public int getOrder() {
        int value = ThesaurusHelper.getOrder(getWikitty());
        return value;
}

    /**
     * setOrder :
     * @param order 
     */

    @Override
    public void setOrder(int order) {
        int oldValue = getOrder();
        ThesaurusHelper.setOrder(getWikitty(), order);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_ORDER, oldValue, getOrder());
}

    /**
     * getComment :
     * @return String 
     */

    @Override
    public String getComment() {
        String value = ThesaurusHelper.getComment(getWikitty());
        return value;
}

    /**
     * setComment :
     * @param comment 
     */

    @Override
    public void setComment(String comment) {
        String oldValue = getComment();
        ThesaurusHelper.setComment(getWikitty(), comment);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_COMMENT, oldValue, getComment());
}

    /**
     * getRootThesaurus :
     * @return String 
     */

    @Override
    public String getRootThesaurus() {
        String value = ThesaurusHelper.getRootThesaurus(getWikitty());
        return value;
}

    /**
     * setRootThesaurus :
     * @param rootThesaurus 
     */

    @Override
    public void setRootThesaurus(String rootThesaurus) {
        String oldValue = getRootThesaurus();
        ThesaurusHelper.setRootThesaurus(getWikitty(), rootThesaurus);
        getPropertyChangeSupport().firePropertyChange(Thesaurus.FIELD_THESAURUS_ROOTTHESAURUS, oldValue, getRootThesaurus());
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        String value = WikittyTreeNodeHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    public void setName(String name) {
        String oldValue = getName();
        WikittyTreeNodeHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_NAME, oldValue, getName());
}

    /**
     * getAttachment :
     * @return Set<String> 
     */

    public Set<String> getAttachment() {
        Set<String> result = WikittyTreeNodeHelper.getAttachment(getWikitty());
        return result;
}

    /**
     * setAttachment :
     * @param attachment 
     */

    public void setAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.setAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAllAttachment :
     * @param attachment 
     */

    public void addAllAttachment(Set<String> attachment) {
        Set<String> oldValue = getAttachment();
        WikittyTreeNodeHelper.addAllAttachment(getWikitty(), attachment);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, oldValue, getAttachment());
}

    /**
     * addAttachment :
     * @param element 
     */

    public void addAttachment(String element) {
        WikittyTreeNodeHelper.addAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * removeAttachment :
     * @param element 
     */

    public void removeAttachment(String element) {
        WikittyTreeNodeHelper.removeAttachment(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * clearAttachment :
     */

    public void clearAttachment() {
        WikittyTreeNodeHelper.clearAttachment(getWikitty());
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_ATTACHMENT, null, getAttachment());
}

    /**
     * getParent :
     * @return String 
     */

    public String getParent() {
        String value = WikittyTreeNodeHelper.getParent(getWikitty());
        return value;
}

    /**
     * setParent :
     * @param parent 
     */

    public void setParent(String parent) {
        String oldValue = getParent();
        WikittyTreeNodeHelper.setParent(getWikitty(), parent);
        getPropertyChangeSupport().firePropertyChange(WikittyTreeNode.FIELD_WIKITTYTREENODE_PARENT, oldValue, getParent());
}

    /**
     * ThesaurusAbstract :
     */

    public ThesaurusAbstract() {
        super();
}

    /**
     * ThesaurusAbstract :
     * @param wikitty 
     */

    public ThesaurusAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * ThesaurusAbstract :
     * @param businessEntityImpl 
     */

    public ThesaurusAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionThesaurus =
                new WikittyExtension(EXT_THESAURUS,
                                     "5.0", // version
                                     WikittyTreeNode.EXT_WIKITTYTREENODE,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String tags[0-*] unique=\"true\"", 
                                             "Numeric order unique=\"true\"", 
                                             "String comment unique=\"true\"", 
                                             "String rootThesaurus unique=\"true\" documentation=\"Root thesaurus wikitty id.\" notNull=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyTreeNodeAbstract.extensions); 
        // current after requires ones

        exts.add(extensionThesaurus);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //ThesaurusAbstract
