package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class QueryMakerAbstract extends BusinessEntityImpl implements QueryMaker {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionQueryMaker;
    /**
     * getQueries :
     * @return Set<String> 
     */

    @Override
    public Set<String> getQueries() {
        Set<String> result = QueryMakerHelper.getQueries(getWikitty());
        return result;
}

    /**
     * setQueries :
     * @param queries 
     */

    @Override
    public void setQueries(Set<String> queries) {
        Set<String> oldValue = getQueries();
        QueryMakerHelper.setQueries(getWikitty(), queries);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, oldValue, getQueries());
}

    /**
     * addAllQueries :
     * @param queries 
     */

    @Override
    public void addAllQueries(Set<String> queries) {
        Set<String> oldValue = getQueries();
        QueryMakerHelper.addAllQueries(getWikitty(), queries);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, oldValue, getQueries());
}

    /**
     * addQueries :
     * @param element 
     */

    @Override
    public void addQueries(String element) {
        QueryMakerHelper.addQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * removeQueries :
     * @param element 
     */

    @Override
    public void removeQueries(String element) {
        QueryMakerHelper.removeQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * clearQueries :
     */

    @Override
    public void clearQueries() {
        QueryMakerHelper.clearQueries(getWikitty());
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * QueryMakerAbstract :
     */

    public QueryMakerAbstract() {
        super();
}

    /**
     * QueryMakerAbstract :
     * @param wikitty 
     */

    public QueryMakerAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * QueryMakerAbstract :
     * @param businessEntityImpl 
     */

    public QueryMakerAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionQueryMaker =
                new WikittyExtension(EXT_QUERYMAKER,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String queries[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionQueryMaker);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //QueryMakerAbstract
