/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.instantrunoff;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.PollenError;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.instantrunoff.InstantRunoffVoteCountingStrategy;

public class InstantRunoffVoteCounting
extends AbstractVoteCounting {
    public InstantRunoffVoteCounting() {
        super(VoteCountings.InstantRunoff);
    }

    public InstantRunoffVoteCountingStrategy newStrategy() {
        return new InstantRunoffVoteCountingStrategy();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(1.0);
    }

    @Override
    public List<PollenError> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        List<PollenError> errors = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue == null) {
            errors.add(new PollenError("voteValue", "pollen.voteCountingType.instantRunoff.voteValue.error.required", null, locale, new Object[0]));
        } else if (voteValue < 0.0) {
            errors.add(new PollenError("voteValue", "pollen.voteCountingType.instantRunoff.voteValue.error.positive", (Object)voteValue, locale, voteValue));
        }
        return errors;
    }
}

