/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.number;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.MinMaxChoicesNumberConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;

public class NumberVoteCountingStrategy
extends AbstractVoteCountingStrategy<MinMaxChoicesNumberConfig> {
    public NumberVoteCountingStrategy() {
        super(MinMaxChoicesNumberConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        for (Voter voter : voters) {
            this.addVoterChoices(voter, scores);
        }
        return this.orderByValues(scores.values(), null);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = 0.0;
            if (choiceScore.getScoreValue() != null) {
                score = choiceScore.getScoreValue().doubleValue();
            }
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected void addVoterChoices(Voter voter, Map<String, ChoiceScore> scores) {
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue == null) continue;
            String choiceId = voteForChoice.getChoiceId();
            ChoiceScore choiceScore = scores.get(choiceId);
            double scoreToAdd = voteValue * voterWeight;
            choiceScore.addScoreValue(scoreToAdd);
        }
    }
}

