/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.utils.ListBehavior;
import org.chorem.pollen.votecounting.utils.PercentageBehavior;

public class Choice
implements ListBehavior<Group>,
PercentageBehavior {
    private String idChoice;
    private String name;
    private double value;
    private List<Group> groups;

    public Choice(String id) {
        this.idChoice = id;
        this.groups = new ArrayList<Group>();
        this.value = 0.0;
    }

    public Choice(String id, String name) {
        this(id);
        this.name = name;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String getIdChoice() {
        return this.idChoice;
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void addGroup(String idGroup, double weight) {
        this.groups.add(new Group(idGroup, weight));
    }

    public Group getGroup(String idGroup) {
        for (Group g : this.groups) {
            if (!g.getIdGroup().equals(idGroup)) continue;
            return g;
        }
        return null;
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public List<Group> list() {
        return this.getGroups();
    }

    public String toString() {
        return "Choice id=" + this.idChoice + " _ value=" + this.value;
    }
}

