/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import java.util.Locale;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.VoteCountingStrategy;
import org.nuiton.i18n.I18n;

public abstract class AbstractVoteCounting<S extends VoteCountingStrategy>
implements VoteCounting<S> {
    protected final int id;
    protected final Class<S> strategyType;
    protected final String i18nName;
    protected final String i18nShortHelp;
    protected final String i18nHelp;

    protected AbstractVoteCounting(int id, Class<S> strategyType, String i18nName, String i18nShortHelp, String i18nHelp) {
        this.id = id;
        this.strategyType = strategyType;
        this.i18nName = i18nName;
        this.i18nShortHelp = i18nShortHelp;
        this.i18nHelp = i18nHelp;
    }

    @Override
    public final S newStrategy() {
        try {
            return (S)((VoteCountingStrategy)this.strategyType.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instanciate strategy", e);
        }
    }

    @Override
    public final String getName(Locale locale) {
        String result = I18n.l_((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
        return result;
    }

    @Override
    public final String getShortHelp(Locale locale) {
        String voteName = I18n.l_((Locale)locale, (String)this.i18nName, (Object[])new Object[0]);
        String voteHelp = I18n.l_((Locale)locale, (String)this.i18nShortHelp, (Object[])new Object[0]);
        String result = I18n.l_((Locale)locale, (String)"pollen.voteCountingType.help", (Object[])new Object[]{voteName, voteHelp});
        return result;
    }

    @Override
    public final String getHelp(Locale locale) {
        String result = I18n.l_((Locale)locale, (String)this.i18nHelp, (Object[])new Object[0]);
        return result;
    }

    @Override
    public final int getId() {
        return this.id;
    }
}

