/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.chorem.pollen.votecounting.model.SimpleVoter;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

public class VoterBuilder {
    private Set<Voter> voters = Sets.newHashSet();
    private Voter voter;

    public VoterBuilder newVoter(String voterId, double weight) {
        this.flushVoter();
        this.voter = SimpleVoter.newVoter(voterId, weight, null);
        return this;
    }

    public VoterBuilder addVoteForChoice(String choiceId, Double voteValue) {
        Preconditions.checkState((this.voter != null ? 1 : 0) != 0);
        VoteForChoice voteForChoice = VoteForChoice.newVote(choiceId, voteValue);
        this.voter.addVoteForChoice(voteForChoice);
        return this;
    }

    public Set<Voter> getVoters() {
        this.flushVoter();
        return this.voters;
    }

    protected void flushVoter() {
        if (this.voter != null) {
            this.voters.add(this.voter);
            this.voter = null;
        }
    }
}

