/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import com.google.common.base.MoreObjects;
import jakarta.mail.Message;
import java.util.List;
import java.util.Optional;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.services.service.mail.PollenMailType;

public class PollenMailReturnContext {
    protected Message message;
    protected PollenMailType mailType;
    protected Poll poll;
    protected Choice choice;
    protected PollenUser user;
    protected Report report;
    protected Comment comment;
    protected PollenPrincipal principal;

    protected static <E extends PollenEntity> E findEntity(List<PollenEntity> entities, Class<E> type) {
        return (E)((PollenEntity)entities.stream().filter(type::isInstance).map(type::cast).findFirst().orElse(null));
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public PollenMailType getMailType() {
        return this.mailType;
    }

    public void setMailType(PollenMailType mailType) {
        this.mailType = mailType;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    public Choice getChoice() {
        return this.choice;
    }

    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    public PollenUser getUser() {
        return this.user;
    }

    public void setUser(PollenUser user) {
        this.user = user;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public PollenPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PollenPrincipal principal) {
        this.principal = principal;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        toStringHelper.add("mailType", (Object)this.mailType);
        Optional.ofNullable(this.poll).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("poll", topiaId));
        Optional.ofNullable(this.choice).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("choice", topiaId));
        Optional.ofNullable(this.user).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("user", topiaId));
        Optional.ofNullable(this.report).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("report", topiaId));
        Optional.ofNullable(this.comment).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("comment", topiaId));
        Optional.ofNullable(this.principal).map(AbstractPollenEntity::getTopiaId).ifPresent(topiaId -> toStringHelper.add("principal", topiaId));
        return toStringHelper.toString();
    }
}

