/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import java.util.function.Function;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.SessionToken;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.services.bean.PollenEntityId;

public class PollenEntityRef<E extends PollenEntity>
extends PollenEntityId<E> {
    protected String permission;

    public static PollenEntityRef<Poll> of(Poll entity) {
        return PollenEntityRef.of(entity, Poll::getCreator);
    }

    public static PollenEntityRef<Choice> of(Choice entity) {
        return PollenEntityRef.of(entity, Choice::getCreator);
    }

    public static PollenEntityRef<Comment> of(Comment entity) {
        return PollenEntityRef.of(entity, Comment::getAuthor);
    }

    public static PollenEntityRef<Vote> of(Vote entity) {
        return PollenEntityRef.of(entity, Vote::getVoter);
    }

    public static PollenEntityRef<PollenUser> of(SessionToken result) {
        return PollenEntityRef.of(result.getPollenUser(), result.getPollenToken());
    }

    public static <E extends PollenEntity> PollenEntityRef<E> of(E result) {
        return new PollenEntityRef<E>(result, null);
    }

    public static <E extends PollenEntity> PollenEntityRef<E> of(E entity, Function<E, PollenPrincipal> getPrincipalFn) {
        PollenToken pollenToken = getPrincipalFn.andThen(PollenPrincipal::getPermission).apply(entity);
        return PollenEntityRef.of(entity, pollenToken);
    }

    public static <E extends PollenEntity> PollenEntityRef<E> of(E entity, PollenToken permission) {
        return new PollenEntityRef<E>(entity, permission == null ? null : permission.getToken());
    }

    public static <E extends PollenEntity> PollenEntityRef<E> ofDecoded(Class<E> entityType, String reducedId, String permission) {
        PollenEntityRef<E> result = new PollenEntityRef<E>(entityType);
        result.setReducedId(reducedId);
        result.decode();
        result.setPermission(permission);
        return result;
    }

    private PollenEntityRef(E entity, String permission) {
        this(entity.getClass());
        this.setEntityId(entity.getTopiaId());
        this.encode();
        this.setPermission(permission);
    }

    private PollenEntityRef(Class<E> entityType) {
        super(entityType);
    }

    public String getPermission() {
        return this.permission;
    }

    private void setPermission(String permission) {
        this.permission = permission;
    }
}

