/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import jakarta.persistence.FlushModeType;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.PollenDao;
import org.chorem.pollen.persistence.PollenDaoSupplier;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.topia.TopiaException;
import org.chorem.pollen.persistence.topia.internal.HibernateProvider;
import org.chorem.pollen.persistence.topia.internal.support.HibernateJpaSupport;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.metamodel.MappingMetamodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollenPersistenceContext
implements PollenDaoSupplier,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(PollenPersistenceContext.class);
    private final Map<Class<? extends PollenEntity>, PollenDao<? extends PollenEntity>> daoCache = Maps.newConcurrentMap();
    private final HibernateProvider hibernateProvider;
    private final HibernateJpaSupport jpaSupport;
    private final Consumer<PollenPersistenceContext> onCloseConsumer;
    private boolean closed = false;
    private Session hibernateSession;

    public void setHibernateSession(Session hibernateSession) {
        this.hibernateSession = hibernateSession;
    }

    public Session getHibernateSession() {
        Preconditions.checkState((this.hibernateSession != null ? 1 : 0) != 0, (Object)"Session is not yet initialized");
        return this.hibernateSession;
    }

    public PollenPersistenceContext(HibernateProvider hibernateProvider, Optional<Duration> slowQueriesThreshold, Consumer<PollenPersistenceContext> onCloseConsumer) {
        this.onCloseConsumer = onCloseConsumer;
        this.hibernateProvider = hibernateProvider;
        this.startTransaction();
        this.jpaSupport = new HibernateJpaSupport(this::getHibernateSession, slowQueriesThreshold);
    }

    public SessionFactory getHibernateFactory() {
        return this.hibernateProvider.getSessionFactory();
    }

    protected void startTransaction() throws TopiaException {
        SessionFactory factory = this.getHibernateFactory();
        Session result = factory.openSession();
        this.setHibernateSession(result);
        result.setFlushMode(FlushModeType.COMMIT);
        try {
            result.beginTransaction();
        }
        catch (Exception eee) {
            block4: {
                try {
                    result.close();
                }
                catch (HibernateException e1) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error("Could not close hibernate session", (Throwable)e1);
                }
            }
            String message = String.format("An error occurs while asking a new transaction: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)("persistence context " + String.valueOf(this) + " is closed"));
    }

    @Override
    public <E extends PollenEntity, D extends PollenDao<E>> D getDao(Class<E> entityClass) {
        boolean found;
        Preconditions.checkArgument((entityClass != null ? 1 : 0) != 0, (Object)"The method 'getDao' requires a non null 'entityClass' parameter");
        SessionFactory hibernateFactory = this.getHibernateFactory();
        Preconditions.checkState((hibernateFactory != null ? 1 : 0) != 0, (Object)"The Hibernate SessionFactory is null, please initialize");
        boolean bl = found = ((MappingMetamodel)hibernateFactory.getMetamodel()).getEntityDescriptor(entityClass.getName()) != null;
        if (!found) {
            String message;
            String format;
            if (log.isInfoEnabled()) {
                format = "List of supported persistence classes: %s";
                message = String.format(format, new Object[]{hibernateFactory.getStatistics().getEntityNames()});
                log.info(message);
            }
            format = "The following entity type %s is not managed by this context, you probably forgot to declare it.";
            message = String.format(format, entityClass.getName());
            throw new TopiaException(message);
        }
        PollenDao dao = this.daoCache.get(entityClass);
        if (dao == null) {
            String daoClassName = entityClass.getName() + "Dao";
            try {
                Class<?> daoClass = Class.forName(daoClassName);
                dao = (PollenDao)daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Unable to instantiate DAO class " + daoClassName, (Throwable)e);
                throw new TopiaException("unable to instantiate DAO class " + daoClassName, e);
            }
            catch (ClassNotFoundException e) {
                log.error("Unable to find DAO class " + daoClassName, (Throwable)e);
                throw new TopiaException("unable to find DAO class " + daoClassName, e);
            }
            if (dao instanceof AbstractPollenDao) {
                AbstractPollenDao abstractPollenDao = (AbstractPollenDao)dao;
                abstractPollenDao.init(this.jpaSupport, this);
            }
            this.daoCache.put(entityClass, dao);
        }
        return (D)dao;
    }

    public void commit() {
        this.checkNotClosed();
        try {
            Session hibernateSession = this.getHibernateSession();
            Transaction transaction = hibernateSession.getTransaction();
            hibernateSession.flush();
            transaction.commit();
            hibernateSession.beginTransaction();
        }
        catch (Exception eee) {
            String message = String.format("An error occurred during commit operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    private void rollback0() {
        try {
            Session hibernateSession = this.getHibernateSession();
            Transaction transaction = hibernateSession.getTransaction();
            hibernateSession.clear();
            transaction.rollback();
            hibernateSession.close();
        }
        catch (HibernateException eee) {
            String message = String.format("An error occurred during rollback operation: %1$s", eee.getMessage());
            throw new TopiaException(message, eee);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.checkNotClosed();
        log.debug("will close {}", (Object)this);
        this.closed = true;
        this.rollback0();
        Session hibernateSession = this.getHibernateSession();
        Preconditions.checkState((!hibernateSession.isOpen() ? 1 : 0) != 0, (Object)"Session should be closed after rollback0(false)");
        log.debug("{} closed", (Object)this);
        this.onCloseConsumer.accept(this);
    }
}

