/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"login","password","firstName","lastName","language","email"},
  boolFields={"administrator"}
)        
public interface UserAccount extends TopiaEntity {

    public static final String LOGIN = "login";

    public static final String PASSWORD = "password";

    public static final String FIRST_NAME = "firstName";

    public static final String LAST_NAME = "lastName";

    public static final String ADMINISTRATOR = "administrator";

    public static final String LANGUAGE = "language";

    public static final String EMAIL = "email";

    public static final String FAVORITE_LIST = "favoriteList";

    public static final String POLL_ACCOUNT = "pollAccount";

    /**
     * @param login La valeur de l'attribut login à positionner.
     */
    public void setLogin(java.lang.String login);

    /**
     * @return La valeur de l'attribut login.
     */
    public java.lang.String getLogin();

    /**
     * @param password La valeur de l'attribut password à positionner.
     */
    public void setPassword(java.lang.String password);

    /**
     * @return La valeur de l'attribut password.
     */
    public java.lang.String getPassword();

    /**
     * @param firstName La valeur de l'attribut firstName à positionner.
     */
    public void setFirstName(java.lang.String firstName);

    /**
     * @return La valeur de l'attribut firstName.
     */
    public java.lang.String getFirstName();

    /**
     * @param lastName La valeur de l'attribut lastName à positionner.
     */
    public void setLastName(java.lang.String lastName);

    /**
     * @return La valeur de l'attribut lastName.
     */
    public java.lang.String getLastName();

    /**
     * @param administrator La valeur de l'attribut administrator à positionner.
     */
    public void setAdministrator(java.lang.Boolean administrator);

    /**
     * @return La valeur de l'attribut administrator.
     */
    public java.lang.Boolean getAdministrator();

    /**
     * @param language La valeur de l'attribut language à positionner.
     */
    public void setLanguage(java.lang.String language);

    /**
     * @return La valeur de l'attribut language.
     */
    public java.lang.String getLanguage();

    /**
     * @param email La valeur de l'attribut email à positionner.
     */
    public void setEmail(java.lang.String email);

    /**
     * @return La valeur de l'attribut email.
     */
    public java.lang.String getEmail();

    /**
     * @param favoriteList L'instance de favoriteList à ajouter.
     */
    public void addFavoriteList(org.chorem.pollen.business.persistence.PersonList favoriteList);

    /**
     * @param favoriteList Les instances de favoriteList à ajouter.
     */
    public void addAllFavoriteList(java.util.List<org.chorem.pollen.business.persistence.PersonList> favoriteList);

    /**
     * @param favoriteList La Collection de favoriteList à positionner.
     */
    public void setFavoriteList(java.util.List<org.chorem.pollen.business.persistence.PersonList> favoriteList);

    /**
     * @param favoriteList L'instance de favoriteList à retirer.
     */
    public void removeFavoriteList(org.chorem.pollen.business.persistence.PersonList favoriteList);

    /**
     * Vide la Collection de favoriteList.
     */
    public void clearFavoriteList();

    /**
     * @return La Liste de favoriteList.
     */
    public java.util.List<org.chorem.pollen.business.persistence.PersonList> getFavoriteList();


    /**
     * Recupère l'attribut favoriteList à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.PersonList getFavoriteListByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection favoriteList.
     */
    public int sizeFavoriteList();

    /**
     * @return <code>true</code> si la collection favoriteList est vide.
     */
    public boolean isFavoriteListEmpty();

    /**
     * @param pollAccount L'instance de pollAccount à ajouter.
     */
    public void addPollAccount(org.chorem.pollen.business.persistence.PollAccount pollAccount);

    /**
     * @param pollAccount Les instances de pollAccount à ajouter.
     */
    public void addAllPollAccount(java.util.List<org.chorem.pollen.business.persistence.PollAccount> pollAccount);

    /**
     * @param pollAccount La Collection de pollAccount à positionner.
     */
    public void setPollAccount(java.util.List<org.chorem.pollen.business.persistence.PollAccount> pollAccount);

    /**
     * @param pollAccount L'instance de pollAccount à retirer.
     */
    public void removePollAccount(org.chorem.pollen.business.persistence.PollAccount pollAccount);

    /**
     * Vide la Collection de pollAccount.
     */
    public void clearPollAccount();

    /**
     * @return La Liste de pollAccount.
     */
    public java.util.List<org.chorem.pollen.business.persistence.PollAccount> getPollAccount();


    /**
     * Recupère l'attribut pollAccount à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.PollAccount getPollAccountByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection pollAccount.
     */
    public int sizePollAccount();

    /**
     * @return <code>true</code> si la collection pollAccount est vide.
     */
    public boolean isPollAccountEmpty();

} //UserAccount
