/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Progress;
import org.cache2k.io.LoadExceptionInfo;
import org.cache2k.processor.MutableCacheEntry;

class MutableEntryOnProgress<K, V>
implements MutableCacheEntry<K, V> {
    private final K key;
    private final ExaminationEntry<K, V> entry;
    private final Progress<K, V, ?> progress;
    private final boolean mutationRequested;
    private final boolean originalExists;
    private boolean mutate = false;
    private boolean remove = false;
    private V value = null;
    private boolean setExpiry = false;
    private long expiryTime = -1L;
    private long refreshTime = -1L;
    private Object originalOrLoadedValue = null;
    private boolean dataRead = false;

    MutableEntryOnProgress(K key, Progress<K, V, ?> progress, ExaminationEntry<K, V> entry, boolean mutationRequested) {
        this.entry = entry;
        this.progress = progress;
        this.key = key;
        boolean bl = this.originalExists = entry != null && progress.isDataFreshOrMiss();
        if (this.isEntryValid()) {
            this.originalOrLoadedValue = entry.getValueOrException();
        }
        this.mutationRequested = mutationRequested;
    }

    public long getStartTime() {
        return this.progress.getMutationStartTime();
    }

    public boolean exists() {
        this.triggerInstallationRead();
        return this.originalExists;
    }

    private void dataAccess() {
        this.triggerInstallationRead();
        this.dataRead = true;
    }

    public MutableCacheEntry<K, V> setValue(V v) {
        if (this.entry != null) {
            this.lock();
        }
        this.mutate = true;
        this.remove = false;
        this.value = v;
        return this;
    }

    public MutableCacheEntry<K, V> setException(Throwable ex) {
        if (this.entry != null) {
            this.lock();
        }
        this.mutate = true;
        this.remove = false;
        this.value = new ExceptionWrapper(this.key, this.progress.getMutationStartTime(), ex, this.progress.getExceptionPropagator());
        return this;
    }

    public MutableCacheEntry<K, V> setExpiryTime(long t) {
        this.triggerInstallationRead();
        this.expiryTime = t;
        if (this.isEntryValid()) {
            this.setExpiry = true;
        }
        return this;
    }

    public MutableCacheEntry<K, V> remove() {
        this.triggerInstallationRead();
        if (this.mutate && !this.originalExists) {
            this.mutate = false;
        } else {
            if (this.entry != null) {
                this.lock();
            }
            this.remove = true;
            this.mutate = true;
        }
        this.value = null;
        return this;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        this.triggerLoadOrInstallationRead();
        this.dataRead = true;
        this.checkAndThrowException(this.originalOrLoadedValue);
        return (V)this.originalOrLoadedValue;
    }

    public MutableCacheEntry<K, V> load() {
        if (this.dataRead) {
            throw new IllegalStateException("getValue()/getException()/getModificationTime() called before load");
        }
        if (!this.progress.isLoaderPresent()) {
            throw new UnsupportedOperationException("Loader is not configured");
        }
        if (!this.progress.wasLoaded()) {
            this.triggerLoadOrInstallationRead();
            throw new Operations.NeedsLoadRestartException();
        }
        return this;
    }

    private void triggerLoadOrInstallationRead() {
        this.triggerInstallationRead();
        if (!this.originalExists && !this.progress.wasLoaded() && this.progress.isLoaderPresent()) {
            if (this.mutationRequested) {
                throw new IllegalStateException("getValue() after mutation not supported");
            }
            throw new Operations.NeedsLoadRestartException();
        }
    }

    private void triggerInstallationRead() {
        if (this.entry == null) {
            throw new Operations.WantsDataRestartException();
        }
    }

    public MutableCacheEntry<K, V> lock() {
        if (this.mutationRequested) {
            return this;
        }
        throw new Operations.NeedsLockRestartException();
    }

    private void checkAndThrowException(Object value) {
        if (value instanceof ExceptionWrapper) {
            throw ((ExceptionWrapper)value).generateExceptionToPropagate();
        }
    }

    public Throwable getException() {
        LoadExceptionInfo<K, V> info = this.getExceptionInfo();
        return info != null ? info.getException() : null;
    }

    public LoadExceptionInfo<K, V> getExceptionInfo() {
        this.triggerLoadOrInstallationRead();
        this.dataRead = true;
        if (this.originalOrLoadedValue instanceof ExceptionWrapper) {
            return (ExceptionWrapper)this.originalOrLoadedValue;
        }
        return null;
    }

    public long getExpiryTime() {
        this.dataAccess();
        return this.isEntryValid() ? this.entry.getExpiryTime() : 0L;
    }

    private boolean isEntryValid() {
        return this.originalExists || this.progress.wasLoaded();
    }

    public long getModificationTime() {
        this.dataAccess();
        return this.isEntryValid() ? this.entry.getModificationTime() : 0L;
    }

    public MutableCacheEntry<K, V> setModificationTime(long t) {
        this.refreshTime = t;
        return this;
    }

    public boolean isMutationNeeded() {
        return this.mutate || this.setExpiry;
    }

    public void sendMutationCommand() {
        if (!this.isMutationNeeded()) {
            this.progress.noMutation();
            return;
        }
        if (this.mutate) {
            if (this.remove) {
                this.progress.remove();
                return;
            }
            if (this.expiryTime != -1L || this.refreshTime != -1L) {
                this.progress.putAndSetExpiry(this.value, this.expiryTime, this.refreshTime);
                return;
            }
            this.progress.put(this.value);
            return;
        }
        this.progress.expire(this.expiryTime);
    }
}

