/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.concurrency;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;

public class GlobalThreadFactory
implements ThreadFactory {
    private static final ConcurrentMap<String, String> NAMES_RUNNING = new ConcurrentHashMap<String, String>();
    private final String prefix;

    public GlobalThreadFactory(String threadNamePrefix) {
        this.prefix = threadNamePrefix;
    }

    protected String generateName(int id) {
        return this.prefix + '-' + id;
    }

    @Override
    public Thread newThread(Runnable r) {
        String name;
        int id = 1;
        while (NAMES_RUNNING.putIfAbsent(name = this.generateName(id), name) != null) {
            ++id;
        }
        String finalName = name;
        Runnable myRunnable = () -> {
            try {
                r.run();
            }
            finally {
                NAMES_RUNNING.remove(finalName);
            }
        };
        Thread thr = new Thread(myRunnable);
        thr.setName(name);
        thr.setDaemon(true);
        return thr;
    }
}

