// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avcodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;

import static org.bytedeco.ffmpeg.global.avcodec.*;


@Properties(inherit = org.bytedeco.ffmpeg.presets.avcodec.class)
public class AVBitStreamFilter extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVBitStreamFilter() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVBitStreamFilter(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVBitStreamFilter(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVBitStreamFilter position(long position) {
        return (AVBitStreamFilter)super.position(position);
    }

    public native @Cast("const char*") BytePointer name(); public native AVBitStreamFilter name(BytePointer setter);

    /**
     * A list of codec ids supported by the filter, terminated by
     * AV_CODEC_ID_NONE.
     * May be NULL, in that case the bitstream filter works with any codec id.
     */
    public native @Cast("const AVCodecID*") IntPointer codec_ids(); public native AVBitStreamFilter codec_ids(IntPointer setter);

    /**
     * A class for the private data, used to declare bitstream filter private
     * AVOptions. This field is NULL for bitstream filters that do not declare
     * any options.
     *
     * If this field is non-NULL, the first member of the filter private data
     * must be a pointer to AVClass, which will be set by libavcodec generic
     * code to this class.
     */
    public native @Const AVClass priv_class(); public native AVBitStreamFilter priv_class(AVClass setter);

    /*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavcodec and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     */

    public native int priv_data_size(); public native AVBitStreamFilter priv_data_size(int setter);
    public static class Init_AVBSFContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Init_AVBSFContext(Pointer p) { super(p); }
        protected Init_AVBSFContext() { allocate(); }
        private native void allocate();
        public native int call(AVBSFContext ctx);
    }
    public native Init_AVBSFContext init(); public native AVBitStreamFilter init(Init_AVBSFContext setter);
    public static class Filter_AVBSFContext_AVPacket extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Filter_AVBSFContext_AVPacket(Pointer p) { super(p); }
        protected Filter_AVBSFContext_AVPacket() { allocate(); }
        private native void allocate();
        public native int call(AVBSFContext ctx, AVPacket pkt);
    }
    public native Filter_AVBSFContext_AVPacket filter(); public native AVBitStreamFilter filter(Filter_AVBSFContext_AVPacket setter);
    public static class Close_AVBSFContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Close_AVBSFContext(Pointer p) { super(p); }
        protected Close_AVBSFContext() { allocate(); }
        private native void allocate();
        public native void call(AVBSFContext ctx);
    }
    public native @Name("close") Close_AVBSFContext _close(); public native AVBitStreamFilter _close(Close_AVBSFContext setter);
    public static class Flush_AVBSFContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Flush_AVBSFContext(Pointer p) { super(p); }
        protected Flush_AVBSFContext() { allocate(); }
        private native void allocate();
        public native void call(AVBSFContext ctx);
    }
    public native Flush_AVBSFContext flush(); public native AVBitStreamFilter flush(Flush_AVBSFContext setter);
}
