/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.alg.filter.misc.ImageLambdaFilters;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import org.jetbrains.annotations.Nullable;

public class ImageLambdaFilters_MT {
    public static void filterRectCenterInner(GrayI8 src, int radiusX, int radiusY, GrayI8 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = (byte)filter.apply(indexSrc++, workspace);
            }
        });
    }

    public static void filterRectCenterInner(GrayI16 src, int radiusX, int radiusY, GrayI16 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = (short)filter.apply(indexSrc++, workspace);
            }
        });
    }

    public static void filterRectCenterInner(GrayS32 src, int radiusX, int radiusY, GrayS32 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_S32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        });
    }

    public static void filterRectCenterInner(GrayS64 src, int radiusX, int radiusY, GrayS64 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_S64 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        });
    }

    public static void filterRectCenterInner(GrayF32 src, int radiusX, int radiusY, GrayF32 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_F32 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        });
    }

    public static void filterRectCenterInner(GrayF64 src, int radiusX, int radiusY, GrayF64 dst, @Nullable Object workspace, ImageLambdaFilters.RectCenter_F64 filter) {
        int y0 = radiusY;
        int y1 = src.height - radiusY;
        BoofConcurrency.loopFor((int)y0, (int)y1, y -> {
            int indexSrc = src.startIndex + y * src.stride + radiusX;
            int indexDst = dst.startIndex + y * dst.stride + radiusX;
            int end = src.startIndex + y * src.stride + src.width - radiusX;
            while (indexSrc < end) {
                dst.data[indexDst++] = filter.apply(indexSrc++, workspace);
            }
        });
    }
}

