/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilteredColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.NoFilter;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class FilterToolbar
extends AbstractToolbar {
    private static final String FILTER_ID = "filter";
    private static final long serialVersionUID = 1L;

    public <T, S> FilterToolbar(final DataTable<T, S> table, final FilterForm<T> form, IFilterStateLocator<T> stateLocator) {
        super(table);
        if (table == null) {
            throw new IllegalArgumentException("argument [table] cannot be null");
        }
        if (stateLocator == null) {
            throw new IllegalArgumentException("argument [stateLocator] cannot be null");
        }
        AbstractReadOnlyModel model = new AbstractReadOnlyModel<List<IColumn<T, S>>>(){
            private static final long serialVersionUID = 1L;

            public List<IColumn<T, S>> getObject() {
                LinkedList columnsModels = new LinkedList();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(column);
                }
                return columnsModels;
            }
        };
        ListView filters = new ListView<IColumn<T, S>>("filters", (IModel)model){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IColumn<T, S>> item) {
                IColumn col = (IColumn)item.getModelObject();
                item.setRenderBodyOnly(true);
                NoFilter filter = null;
                if (col instanceof IFilteredColumn) {
                    IFilteredColumn filteredCol = (IFilteredColumn)col;
                    filter = filteredCol.getFilter(FilterToolbar.FILTER_ID, form);
                }
                if (filter == null) {
                    filter = new NoFilter(FilterToolbar.FILTER_ID);
                } else if (!filter.getId().equals(FilterToolbar.FILTER_ID)) {
                    throw new IllegalStateException("filter component returned  with an invalid component id. invalid component id [" + filter.getId() + "] required component id [" + this.getId() + "] generating column [" + col.toString() + "] ");
                }
                item.add(new Component[]{filter});
            }
        };
        filters.setReuseItems(true);
        this.add(new Component[]{filters});
    }

    protected void onBeforeRender() {
        if (this.findParent(FilterForm.class) == null) {
            throw new IllegalStateException("FilterToolbar must be contained within a Form");
        }
        super.onBeforeRender();
    }
}

