/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> instanceMap = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource ds) {
        int max = 0;
        for (String s : instanceMap.keySet()) {
            if (s == null) continue;
            try {
                max = Math.max(max, Integer.parseInt(s));
            }
            catch (NumberFormatException e) {}
        }
        String instanceKey = String.valueOf(max + 1);
        instanceMap.put(instanceKey, ds);
        return instanceKey;
    }

    static void removeInstance(String key) {
        if (key != null) {
            instanceMap.remove(key);
        }
    }

    public static void closeAll() throws Exception {
        Iterator<Map.Entry<String, InstanceKeyDataSource>> instanceIterator = instanceMap.entrySet().iterator();
        while (instanceIterator.hasNext()) {
            instanceIterator.next().getValue().close();
        }
        instanceMap.clear();
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws IOException, ClassNotFoundException {
        Reference ref;
        InstanceKeyDataSource obj = null;
        if (refObj instanceof Reference && this.isCorrectClass((ref = (Reference)refObj).getClassName())) {
            RefAddr ra = ref.get("instanceKey");
            if (ra != null && ra.getContent() != null) {
                obj = instanceMap.get(ra.getContent());
            } else {
                String key = null;
                if (name != null) {
                    key = name.toString();
                    obj = instanceMap.get(key);
                }
                if (obj == null) {
                    InstanceKeyDataSource ds = this.getNewInstance(ref);
                    this.setCommonProperties(ref, ds);
                    obj = ds;
                    if (key != null) {
                        instanceMap.put(key, ds);
                    }
                }
            }
        }
        return obj;
    }

    private void setCommonProperties(Reference ref, InstanceKeyDataSource ikds) throws IOException, ClassNotFoundException {
        RefAddr ra = ref.get("dataSourceName");
        if (ra != null && ra.getContent() != null) {
            ikds.setDataSourceName(ra.getContent().toString());
        }
        if ((ra = ref.get("description")) != null && ra.getContent() != null) {
            ikds.setDescription(ra.getContent().toString());
        }
        if ((ra = ref.get("jndiEnvironment")) != null && ra.getContent() != null) {
            byte[] serialized = (byte[])ra.getContent();
            ikds.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(serialized));
        }
        if ((ra = ref.get("loginTimeout")) != null && ra.getContent() != null) {
            ikds.setLoginTimeout(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("blockWhenExhausted")) != null && ra.getContent() != null) {
            ikds.setDefaultBlockWhenExhausted(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("evictionPolicyClassName")) != null && ra.getContent() != null) {
            ikds.setDefaultEvictionPolicyClassName(ra.getContent().toString());
        }
        if ((ra = ref.get("lifo")) != null && ra.getContent() != null) {
            ikds.setDefaultLifo(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxIdlePerKey")) != null && ra.getContent() != null) {
            ikds.setDefaultMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxTotalPerKey")) != null && ra.getContent() != null) {
            ikds.setDefaultMaxTotal(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxWaitMillis")) != null && ra.getContent() != null) {
            ikds.setDefaultMaxWaitMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("minEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
            ikds.setDefaultMinEvictableIdleTimeMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("minIdlePerKey")) != null && ra.getContent() != null) {
            ikds.setDefaultMinIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("numTestsPerEvictionRun")) != null && ra.getContent() != null) {
            ikds.setDefaultNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("softMinEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
            ikds.setDefaultSoftMinEvictableIdleTimeMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnCreate")) != null && ra.getContent() != null) {
            ikds.setDefaultTestOnCreate(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnBorrow")) != null && ra.getContent() != null) {
            ikds.setDefaultTestOnBorrow(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnReturn")) != null && ra.getContent() != null) {
            ikds.setDefaultTestOnReturn(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("testWhileIdle")) != null && ra.getContent() != null) {
            ikds.setDefaultTestWhileIdle(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null && ra.getContent() != null) {
            ikds.setDefaultTimeBetweenEvictionRunsMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("validationQuery")) != null && ra.getContent() != null) {
            ikds.setValidationQuery(ra.getContent().toString());
        }
        if ((ra = ref.get("validationQueryTimeout")) != null && ra.getContent() != null) {
            ikds.setValidationQueryTimeout(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("rollbackAfterValidation")) != null && ra.getContent() != null) {
            ikds.setRollbackAfterValidation(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxConnLifetimeMillis")) != null && ra.getContent() != null) {
            ikds.setMaxConnLifetimeMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultAutoCommit")) != null && ra.getContent() != null) {
            ikds.setDefaultAutoCommit(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultTransactionIsolation")) != null && ra.getContent() != null) {
            ikds.setDefaultTransactionIsolation(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultReadOnly")) != null && ra.getContent() != null) {
            ikds.setDefaultReadOnly(Boolean.valueOf(ra.getContent().toString()));
        }
    }

    protected abstract boolean isCorrectClass(String var1);

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = in.readObject();
            return object;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

