/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

class KeyedCPDSConnectionFactory
implements KeyedPooledObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final int _validationQueryTimeout;
    private final boolean _rollbackAfterValidation;
    private KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> _pool;
    private long maxConnLifetimeMillis = -1L;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, String validationQuery, int validationQueryTimeout, boolean rollbackAfterValidation) {
        this._cpds = cpds;
        this._validationQuery = validationQuery;
        this._validationQueryTimeout = validationQueryTimeout;
        this._rollbackAfterValidation = rollbackAfterValidation;
    }

    public void setPool(KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool) {
        this._pool = pool;
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this._pool;
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject(UserPassKey upkey) throws Exception {
        PooledConnectionAndInfo pci = null;
        PooledConnection pc = null;
        String username = upkey.getUsername();
        String password = upkey.getPassword();
        pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, password);
        if (pc == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pc.addConnectionEventListener(this);
        pci = new PooledConnectionAndInfo(pc, username, password);
        this.pcMap.put(pc, pci);
        return new DefaultPooledObject<PooledConnectionAndInfo>(pci);
    }

    @Override
    public void destroyObject(UserPassKey key, PooledObject<PooledConnectionAndInfo> p) throws Exception {
        PooledConnection pc = p.getObject().getPooledConnection();
        pc.removeConnectionEventListener(this);
        this.pcMap.remove(pc);
        pc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateObject(UserPassKey key, PooledObject<PooledConnectionAndInfo> p) {
        try {
            this.validateLifetime(p);
        }
        catch (Exception e) {
            return false;
        }
        boolean valid = false;
        PooledConnection pconn = p.getObject().getPooledConnection();
        if (null == this._validationQuery) {
            int timeout = this._validationQueryTimeout;
            if (timeout < 0) {
                timeout = 0;
            }
            try {
                return pconn.getConnection().isValid(timeout);
            }
            catch (SQLException e) {
                return false;
            }
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rset = null;
        this.validatingSet.add(pconn);
        try {
            conn = pconn.getConnection();
            stmt = conn.createStatement();
            rset = stmt.executeQuery(this._validationQuery);
            valid = rset.next();
            if (this._rollbackAfterValidation) {
                conn.rollback();
            }
            Utils.closeQuietly(rset);
        }
        catch (Exception e) {
            valid = false;
            return valid;
        }
        finally {
            Utils.closeQuietly(rset);
            Utils.closeQuietly(stmt);
            Utils.closeQuietly(conn);
            this.validatingSet.remove(pconn);
        }
        Utils.closeQuietly(stmt);
        Utils.closeQuietly(conn);
        this.validatingSet.remove(pconn);
        return valid;
    }

    @Override
    public void passivateObject(UserPassKey key, PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    @Override
    public void activateObject(UserPassKey key, PooledObject<PooledConnectionAndInfo> p) throws Exception {
        this.validateLifetime(p);
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingSet.contains(pc)) {
            PooledConnectionAndInfo pci = this.pcMap.get(pc);
            if (pci == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(pci.getUserPassKey(), pci);
            }
            catch (Exception e) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pc.removeConnectionEventListener(this);
                try {
                    this._pool.invalidateObject(pci.getUserPassKey(), pci);
                }
                catch (Exception e3) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pci);
                    e3.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (null != event.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + event.getSQLException() + ")");
        }
        pc.removeConnectionEventListener(this);
        PooledConnectionAndInfo info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(info.getUserPassKey(), info);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + info);
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pc) throws SQLException {
        PooledConnectionAndInfo info = this.pcMap.get(pc);
        if (info == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey key = info.getUserPassKey();
        try {
            this._pool.invalidateObject(key, info);
            this._pool.clear(key);
        }
        catch (Exception ex) {
            throw new SQLException("Error invalidating connection", ex);
        }
    }

    @Override
    public void setPassword(String password) {
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    @Override
    public void closePool(String username) throws SQLException {
        try {
            this._pool.clear(new UserPassKey(username, null));
        }
        catch (Exception ex) {
            throw new SQLException("Error closing connection pool", ex);
        }
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> p) throws Exception {
        long lifetime;
        if (this.maxConnLifetimeMillis > 0L && (lifetime = System.currentTimeMillis() - p.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetime, this.maxConnLifetimeMillis));
        }
    }
}

