/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class MapperListener
implements ContainerListener,
LifecycleListener {
    private static final Log log = LogFactory.getLog(MapperListener.class);
    private Mapper mapper = null;
    private Connector connector = null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.connector");
    private String domain = null;

    public MapperListener(Mapper mapper, Connector connector) {
        this.mapper = mapper;
        this.connector = connector;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void init() {
        Container[] conHosts;
        this.findDefaultHost();
        Engine engine = (Engine)this.connector.getService().getContainer();
        engine.addContainerListener(this);
        for (Container conHost : conHosts = engine.findChildren()) {
            Host host = (Host)conHost;
            if (LifecycleState.NEW.equals((Object)host.getState())) continue;
            host.addLifecycleListener(this);
            this.registerHost(host);
        }
    }

    public void destroy() {
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        if (event.getType() == "addChild") {
            Container child = (Container)event.getData();
            child.addLifecycleListener(this);
            child.addContainerListener(this);
            if (child instanceof Host) {
                this.registerHost((Host)child);
            } else if (child instanceof Context) {
                this.registerContext((Context)child);
            } else if (child instanceof Wrapper) {
                this.registerWrapper((Wrapper)child);
            }
        } else if (event.getType() == "removeChild") {
            Container child = (Container)event.getData();
            this.removeListeners(child);
            if (child instanceof Host) {
                this.unregisterHost((Host)child);
            } else if (child instanceof Context) {
                this.unregisterContext((Context)child);
            } else if (child instanceof Wrapper) {
                this.unregisterWrapper((Wrapper)child);
            }
        } else if (event.getType() == "addAlias") {
            this.mapper.addHostAlias(((Host)event.getSource()).getName(), event.getData().toString());
        } else if (event.getType() == "removeAlias") {
            this.mapper.removeHostAlias(event.getData().toString());
        } else if (event.getType() == "addMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            String contextName = wrapper.getParent().getName();
            if ("/".equals(contextName)) {
                contextName = "";
            }
            String hostName = wrapper.getParent().getParent().getName();
            String mapping = (String)event.getData();
            boolean jspWildCard = "jsp".equals(wrapper.getName()) && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mapping, (Object)wrapper, jspWildCard);
        } else if (event.getType() == "removeMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            String contextName = wrapper.getParent().getName();
            if ("/".equals(contextName)) {
                contextName = "";
            }
            String hostName = wrapper.getParent().getParent().getName();
            String mapping = (String)event.getData();
            this.mapper.removeWrapper(hostName, contextName, mapping);
        } else if (event.getType() == "addWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextName = context.getName();
            if ("/".equals(contextName)) {
                contextName = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.addWelcomeFile(hostName, contextName, welcomeFile);
        } else if (event.getType() == "removeWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextName = context.getName();
            if ("/".equals(contextName)) {
                contextName = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.removeWelcomeFile(hostName, contextName, welcomeFile);
        } else if (event.getType() == "clearWelcomeFiles") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextName = context.getName();
            if ("/".equals(contextName)) {
                contextName = "";
            }
            this.mapper.clearWelcomeFiles(hostName, contextName);
        }
    }

    private void findDefaultHost() {
        Engine engine = (Engine)this.connector.getService().getContainer();
        String defaultHost = engine.getDefaultHost();
        boolean found = false;
        if (defaultHost != null && defaultHost.length() > 0) {
            Container[] containers;
            block0: for (Container container : containers = engine.findChildren()) {
                String[] aliases;
                Host host = (Host)container;
                if (defaultHost.equalsIgnoreCase(host.getName())) {
                    found = true;
                    break;
                }
                for (String alias : aliases = host.findAliases()) {
                    if (!defaultHost.equalsIgnoreCase(alias)) continue;
                    found = true;
                    continue block0;
                }
            }
        }
        if (found) {
            this.mapper.setDefaultHostName(defaultHost);
        } else {
            log.warn((Object)sm.getString("mapperListener.unknownDefaultHost", new Object[]{defaultHost}));
        }
    }

    private void registerHost(Host host) {
        String[] aliases = host.findAliases();
        this.mapper.addHost(host.getName(), aliases, (Object)host.getObjectName());
        host.addContainerListener(this);
        for (Container container : host.findChildren()) {
            this.registerContext((Context)container);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerHost", new Object[]{host.getName(), this.domain}));
        }
    }

    private void unregisterHost(Host host) {
        String hostname = host.getName();
        this.mapper.removeHost(hostname);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterHost", new Object[]{hostname, this.domain}));
        }
    }

    private void unregisterWrapper(Wrapper wrapper) {
        String[] mappings;
        String contextName = wrapper.getParent().getName();
        if ("/".equals(contextName)) {
            contextName = "";
        }
        String hostName = wrapper.getParent().getParent().getName();
        for (String mapping : mappings = wrapper.findMappings()) {
            this.mapper.removeWrapper(hostName, contextName, mapping);
        }
    }

    private void registerContext(Context context) {
        String contextName = context.getName();
        if ("/".equals(contextName)) {
            contextName = "";
        }
        String hostName = context.getParent().getName();
        DirContext resources = context.getResources();
        String[] welcomeFiles = context.findWelcomeFiles();
        this.mapper.addContext(hostName, contextName, (Object)context, welcomeFiles, (javax.naming.Context)resources);
        context.addContainerListener(this);
        for (Container container : context.findChildren()) {
            this.registerWrapper((Wrapper)container);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerContext", new Object[]{contextName}));
        }
    }

    private void unregisterContext(Context context) {
        if (context.getPaused()) {
            return;
        }
        String contextName = context.getName();
        if ("/".equals(contextName)) {
            contextName = "";
        }
        String hostName = context.getParent().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterContext", new Object[]{contextName}));
        }
        this.mapper.removeContext(hostName, contextName);
    }

    private void registerWrapper(Wrapper wrapper) {
        String[] mappings;
        String wrapperName = wrapper.getName();
        String contextName = wrapper.getParent().getName();
        if ("/".equals(contextName)) {
            contextName = "";
        }
        String hostName = wrapper.getParent().getParent().getName();
        for (String mapping : mappings = wrapper.findMappings()) {
            boolean jspWildCard = wrapperName.equals("jsp") && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mapping, (Object)wrapper, jspWildCard);
        }
        wrapper.addContainerListener(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerWrapper", new Object[]{wrapperName, contextName}));
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.registerWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.registerContext((Context)obj);
            } else if (obj instanceof Host) {
                this.registerHost((Host)obj);
            }
        } else if (event.getType() == "before_stop") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.unregisterWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.unregisterContext((Context)obj);
            } else if (obj instanceof Host) {
                this.unregisterHost((Host)obj);
            }
        }
    }

    private void removeListeners(Container container) {
        container.removeContainerListener(this);
        container.removeLifecycleListener(this);
        for (Container child : container.findChildren()) {
            this.removeListeners(child);
        }
    }
}

