/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tomcat.maven.common.deployer.TomcatManagerException;
import org.apache.tomcat.maven.plugin.tomcat6.AbstractWarCatalinaMojo;

public abstract class AbstractDeployMojo
extends AbstractWarCatalinaMojo {
    @Parameter(property="maven.tomcat.mode", defaultValue="war", required=true)
    private String mode;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/META-INF/context.xml")
    private File contextFile;
    @Parameter(property="maven.tomcat.update", defaultValue="false", required=true)
    private boolean update;
    @Parameter(property="maven.tomcat.tag")
    private String tag;

    public void invokeManager() throws MojoExecutionException, TomcatManagerException, IOException {
        if ("war".equals(this.mode)) {
            this.deployWar();
        } else if ("context".equals(this.mode)) {
            this.deployContext();
        } else if ("both".equals(this.mode)) {
            this.deployWarAndContext();
        } else {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractDeployMojo.unknownMode", (Object)this.mode));
        }
    }

    protected abstract File getWarFile();

    protected abstract void validateWarFile() throws MojoExecutionException;

    protected File getContextFile() {
        return this.contextFile;
    }

    protected void validateContextFile() throws MojoExecutionException {
        if (!this.contextFile.exists() || !this.contextFile.isFile()) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractDeployMojo.missingContext", (Object)this.contextFile.getPath()));
        }
    }

    protected boolean isUpdate() {
        return this.update;
    }

    protected String getTag() {
        return this.tag;
    }

    protected void deployWar() throws MojoExecutionException, TomcatManagerException, IOException {
        this.validateWarFile();
        this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractDeployMojo.deployingWar", (Object)this.getDeployedURL()));
        URL warURL = this.getWarFile().toURL();
        this.log(this.getManager().deploy(this.getPath(), warURL, this.isUpdate(), this.getTag()).getHttpResponseBody());
    }

    protected void deployContext() throws MojoExecutionException, TomcatManagerException, IOException {
        this.validateContextFile();
        this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractDeployMojo.deployingContext", (Object)this.getDeployedURL()));
        URL contextURL = this.getContextFile().toURL();
        this.log(this.getManager().deployContext(this.getPath(), contextURL, this.isUpdate(), this.getTag()).getHttpResponseBody());
    }

    protected void deployWarAndContext() throws MojoExecutionException, TomcatManagerException, IOException {
        this.validateWarFile();
        this.validateContextFile();
        this.getLog().info((CharSequence)this.messagesProvider.getMessage("AbstractDeployMojo.deployingWarContext", (Object)this.getDeployedURL()));
        URL warURL = this.getWarFile().toURL();
        URL contextURL = this.getContextFile().toURL();
        this.log(this.getManager().deployContext(this.getPath(), contextURL, warURL, this.isUpdate(), this.getTag()).getHttpResponseBody());
    }
}

