/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.upload.internal.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.tapestry.upload.internal.services.UploadMessages;
import org.apache.tapestry.upload.services.UploadedFile;

public class UploadedFileItem
implements UploadedFile {
    private final FileItem _item;

    public UploadedFileItem(FileItem item) {
        this._item = item;
    }

    public String getContentType() {
        return this._item.getContentType();
    }

    public String getFileName() {
        return FilenameUtils.getName((String)this.getFilePath());
    }

    public String getFilePath() {
        return this._item.getName();
    }

    public long getSize() {
        return this._item.getSize();
    }

    public InputStream getStream() {
        try {
            return this._item.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(UploadMessages.unableToOpenContentFile(this), e);
        }
    }

    public boolean isInMemory() {
        return this._item.isInMemory();
    }

    public void write(File file) {
        try {
            this._item.write(file);
        }
        catch (Exception e) {
            throw new RuntimeException(UploadMessages.writeFailure(file), e);
        }
    }

    public void cleanup() {
        this._item.delete();
    }
}

