/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.upload.internal.services;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.tapestry.ioc.annotations.Inject;
import org.apache.tapestry.ioc.annotations.Symbol;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ThreadCleanupListener;
import org.apache.tapestry.upload.internal.services.ParametersServletRequestWrapper;
import org.apache.tapestry.upload.internal.services.UploadMessages;
import org.apache.tapestry.upload.internal.services.UploadedFileItem;
import org.apache.tapestry.upload.services.MultipartDecoder;
import org.apache.tapestry.upload.services.UploadedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartDecoderImpl
implements MultipartDecoder,
ThreadCleanupListener {
    private final Map<String, UploadedFileItem> _uploads = CollectionFactory.newMap();
    private final String _repositoryLocation;
    private final int _repositoryThreshold;
    private final long _maxRequestSize;
    private final long _maxFileSize;

    public MultipartDecoderImpl(@Inject @Symbol(value="upload.repository-location") String repositoryLocation, @Symbol(value="upload.repository-threshold") int repositoryThreshold, @Symbol(value="upload.requestsize-max") long maxRequestSize, @Symbol(value="upload.filesize-max") long maxFileSize) {
        this._repositoryLocation = repositoryLocation;
        this._repositoryThreshold = repositoryThreshold;
        this._maxRequestSize = maxRequestSize;
        this._maxFileSize = maxFileSize;
    }

    @Override
    public UploadedFile getFileUpload(String parameterName) {
        return this._uploads.get(parameterName);
    }

    @Override
    public HttpServletRequest decode(HttpServletRequest request) {
        List<FileItem> fileItems = this.parseRequest(request);
        return this.processFileItems(request, fileItems);
    }

    public void threadDidCleanup() {
        for (UploadedFileItem uploaded : this._uploads.values()) {
            uploaded.cleanup();
        }
    }

    protected List<FileItem> parseRequest(HttpServletRequest request) {
        try {
            return this.createFileUpload().parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new RuntimeException(UploadMessages.unableToDecode(), e);
        }
    }

    protected ServletFileUpload createFileUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory(this._repositoryThreshold, new File(this._repositoryLocation));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this._maxRequestSize);
        upload.setFileSizeMax(this._maxFileSize);
        return upload;
    }

    protected HttpServletRequest processFileItems(HttpServletRequest request, List<FileItem> fileItems) {
        if (fileItems == null || fileItems.isEmpty()) {
            return request;
        }
        ParametersServletRequestWrapper wrapper = new ParametersServletRequestWrapper(request);
        String encoding = request.getCharacterEncoding();
        for (FileItem item : fileItems) {
            if (item.isFormField()) {
                String fieldValue;
                try {
                    fieldValue = encoding == null ? item.getString() : item.getString(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    fieldValue = item.getString();
                }
                wrapper.addParameter(item.getFieldName(), fieldValue);
                continue;
            }
            wrapper.addParameter(item.getFieldName(), item.getName());
            this.addUploadedFile(item.getFieldName(), new UploadedFileItem(item));
        }
        return wrapper;
    }

    protected void addUploadedFile(String name, UploadedFileItem file) {
        this._uploads.put(name, file);
    }
}

