/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.WildcardUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.json.SerializationParams;
import org.apache.struts2.json.smd.SMD;
import org.apache.struts2.json.smd.SMDGenerator;

public class JSONResult
implements Result {
    private static final long serialVersionUID = 8624350183189931165L;
    private static final Logger LOG = LogManager.getLogger(JSONResult.class);
    public static final String DEFAULT_PARAM = null;
    private String encoding;
    private String defaultEncoding = "UTF-8";
    private List<Pattern> includeProperties;
    private List<Pattern> excludeProperties;
    private String root;
    private boolean wrapWithComments;
    private boolean prefix;
    private boolean enableSMD = false;
    private boolean enableGZIP = false;
    private boolean ignoreHierarchy = true;
    private boolean ignoreInterfaces = true;
    private boolean enumAsBean = false;
    private boolean noCache = false;
    private boolean cacheBeanInfo = true;
    private boolean excludeNullProperties = false;
    private String defaultDateFormat = null;
    private int statusCode;
    private int errorCode;
    private String callbackParameter;
    private String contentType;
    private String wrapPrefix;
    private String wrapSuffix;
    private boolean devMode = false;

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String val) {
        this.devMode = BooleanUtils.toBoolean((String)val);
    }

    public List<Pattern> getExcludePropertiesList() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(String commaDelim) {
        Set<String> excludePatterns = JSONUtil.asSet(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(Pattern.compile(pattern));
            }
        }
    }

    public void setExcludeWildcards(String commaDelim) {
        Set<String> excludePatterns = JSONUtil.asSet(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(WildcardUtil.compileWildcardPattern((String)pattern));
            }
        }
    }

    public List<Pattern> getIncludePropertiesList() {
        return this.includeProperties;
    }

    public void setIncludeProperties(String commaDelim) {
        this.includeProperties = JSONUtil.processIncludePatterns(JSONUtil.asSet(commaDelim), "regexp");
    }

    public void setIncludeWildcards(String commaDelim) {
        this.includeProperties = JSONUtil.processIncludePatterns(JSONUtil.asSet(commaDelim), "wildcard");
    }

    public void execute(ActionInvocation invocation) throws Exception {
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        this.cacheBeanInfo = !this.devMode;
        try {
            Object rootObject = this.readRootObject(invocation);
            this.writeToResponse(response, this.createJSONString(request, rootObject), this.enableGzip(request));
        }
        catch (IOException exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    protected Object readRootObject(ActionInvocation invocation) {
        if (this.enableSMD) {
            return this.buildSMDObject(invocation);
        }
        return this.findRootObject(invocation);
    }

    protected Object findRootObject(ActionInvocation invocation) {
        Object rootObject;
        if (this.root != null) {
            ValueStack stack = invocation.getStack();
            rootObject = stack.findValue(this.root);
        } else {
            rootObject = invocation.getStack().peek();
        }
        return rootObject;
    }

    protected String createJSONString(HttpServletRequest request, Object rootObject) throws JSONException {
        String json = JSONUtil.serialize(rootObject, this.excludeProperties, this.includeProperties, this.ignoreHierarchy, this.enumAsBean, this.excludeNullProperties, this.defaultDateFormat, this.cacheBeanInfo);
        json = this.addCallbackIfApplicable(request, json);
        return json;
    }

    protected boolean enableGzip(HttpServletRequest request) {
        return this.enableGZIP && JSONUtil.isGzipInRequest(request);
    }

    protected void writeToResponse(HttpServletResponse response, String json, boolean gzip) throws IOException {
        JSONUtil.writeJSONToResponse(new SerializationParams(response, this.getEncoding(), this.isWrapWithComments(), json, false, gzip, this.noCache, this.statusCode, this.errorCode, this.prefix, this.contentType, this.wrapPrefix, this.wrapSuffix));
    }

    protected SMD buildSMDObject(ActionInvocation invocation) {
        return new SMDGenerator(this.findRootObject(invocation), this.excludeProperties, this.ignoreInterfaces).generate(invocation);
    }

    protected String getEncoding() {
        String encoding = this.encoding;
        if (encoding == null) {
            encoding = this.defaultEncoding;
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected String addCallbackIfApplicable(HttpServletRequest request, String json) {
        String callbackName;
        if (this.callbackParameter != null && this.callbackParameter.length() > 0 && StringUtils.isNotEmpty((CharSequence)(callbackName = request.getParameter(this.callbackParameter)))) {
            json = callbackName + "(" + json + ")";
        }
        return json;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public boolean isWrapWithComments() {
        return this.wrapWithComments;
    }

    public void setWrapWithComments(boolean wrapWithComments) {
        this.wrapWithComments = wrapWithComments;
    }

    public boolean isEnableSMD() {
        return this.enableSMD;
    }

    public void setEnableSMD(boolean enableSMD) {
        this.enableSMD = enableSMD;
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setIgnoreInterfaces(boolean ignoreInterfaces) {
        this.ignoreInterfaces = ignoreInterfaces;
    }

    public void setEnumAsBean(boolean enumAsBean) {
        this.enumAsBean = enumAsBean;
    }

    public boolean isEnumAsBean() {
        return this.enumAsBean;
    }

    public boolean isEnableGZIP() {
        return this.enableGZIP;
    }

    public void setEnableGZIP(boolean enableGZIP) {
        this.enableGZIP = enableGZIP;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isIgnoreHierarchy() {
        return this.ignoreHierarchy;
    }

    public boolean isExcludeNullProperties() {
        return this.excludeNullProperties;
    }

    public void setExcludeNullProperties(boolean excludeNullProperties) {
        this.excludeNullProperties = excludeNullProperties;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setCallbackParameter(String callbackParameter) {
        this.callbackParameter = callbackParameter;
    }

    public String getCallbackParameter() {
        return this.callbackParameter;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getWrapPrefix() {
        return this.wrapPrefix;
    }

    public void setWrapPrefix(String wrapPrefix) {
        this.wrapPrefix = wrapPrefix;
    }

    public String getWrapSuffix() {
        return this.wrapSuffix;
    }

    public void setWrapSuffix(String wrapSuffix) {
        this.wrapSuffix = wrapSuffix;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    @Inject(required=false, value="struts.json.dateformat")
    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }
}

