/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dojo.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.ClosingUIBean;
import org.apache.struts2.dojo.components.Tree;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="treenode", tldTagClass="org.apache.struts2.dojo.views.jsp.ui.TreeNodeTag", description="Render a tree node within a tree widget.")
public class TreeNode
extends ClosingUIBean {
    private static final String TEMPLATE = "treenode-close";
    private static final String OPEN_TEMPLATE = "treenode";
    private static final transient Random RANDOM = new Random();

    public TreeNode(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "ajax";
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        Boolean parseContent = (Boolean)this.stack.getContext().get("struts.dojo.head.parseContent");
        boolean generateId = parseContent != null ? !parseContent.booleanValue() : true;
        this.addParameter("pushId", generateId);
        if ((this.id == null || this.id.length() == 0) && generateId) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "widget_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
        Tree parentTree = (Tree)this.findAncestor(Tree.class);
        parentTree.addChildrenId(this.id);
    }

    @StrutsTagAttribute(description="Label expression used for rendering tree node label.", required=true)
    public void setLabel(String label) {
        super.setLabel(label);
    }

    @StrutsTagAttribute(description="The css class to use for element")
    public void setCssClass(String cssClass) {
        super.setCssClass(cssClass);
    }

    @StrutsTagAttribute(description="The css style to use for element")
    public void setCssStyle(String cssStyle) {
        super.setCssStyle(cssStyle);
    }

    @StrutsTagAttribute(description="The id to use for the element")
    public void setId(String id) {
        super.setId(id);
    }

    @StrutsTagAttribute(description="The name to set for element")
    public void setName(String name) {
        super.setName(name);
    }
}

