/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import com.opensymphony.xwork2.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.ActionNameBuilder;

public class DefaultActionNameBuilder
implements ActionNameBuilder {
    private String actionSuffix = "Action";
    private boolean lowerCase;

    @Inject
    public DefaultActionNameBuilder(@Inject(value="struts.convention.action.name.lowercase") String lowerCase) {
        this.lowerCase = Boolean.parseBoolean(lowerCase);
    }

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((String)actionSuffix)) {
            this.actionSuffix = actionSuffix;
        }
    }

    public String build(String className) {
        String actionName = className;
        if (actionName.endsWith(this.actionSuffix)) {
            actionName = actionName.substring(0, actionName.length() - this.actionSuffix.length());
        }
        if (this.lowerCase && actionName.length() > 1) {
            int lowerPos = actionName.lastIndexOf(47) + 1;
            StringBuilder sb = new StringBuilder();
            sb.append(actionName.substring(0, lowerPos));
            sb.append(Character.toLowerCase(actionName.charAt(lowerPos)));
            sb.append(actionName.substring(lowerPos + 1));
            actionName = sb.toString();
        }
        return actionName;
    }
}

