/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UpdateStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String collection;
    private String zkHost;
    private boolean waitFlush;
    private boolean waitSearcher;
    private boolean softCommit;
    private int commitBatchSize;
    private TupleStream tupleSource;
    private transient SolrClientCache clientCache;
    private transient boolean doCloseCache;
    private long docsSinceCommit;

    public CommitStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        String zkHost = this.findZkHost(factory, collectionName, expression);
        int batchSize = factory.getIntOperand(expression, "batchSize", 0);
        boolean waitFlush = factory.getBooleanOperand(expression, "waitFlush", false);
        boolean waitSearcher = factory.getBooleanOperand(expression, "waitSearcher", false);
        boolean softCommit = factory.getBooleanOperand(expression, "softCommit", false);
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        if (batchSize < 0) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - batchSize cannot be less than 0 but is '%d'", expression, batchSize));
        }
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        StreamExpression sourceStreamExpression = streamExpressions.get(0);
        this.init(collectionName, factory.constructStream(sourceStreamExpression), zkHost, batchSize, waitFlush, waitSearcher, softCommit);
    }

    public CommitStream(String collectionName, TupleStream tupleSource, String zkHost, int batchSize, boolean waitFlush, boolean waitSearcher, boolean softCommit) throws IOException {
        if (batchSize < 0) {
            throw new IOException(String.format(Locale.ROOT, "batchSize '%d' cannot be less than 0.", batchSize));
        }
        this.init(collectionName, tupleSource, zkHost, batchSize, waitFlush, waitSearcher, softCommit);
    }

    private void init(String collectionName, TupleStream tupleSource, String zkHost, int batchSize, boolean waitFlush, boolean waitSearcher, boolean softCommit) {
        this.collection = collectionName;
        this.zkHost = zkHost;
        this.commitBatchSize = batchSize;
        this.waitFlush = waitFlush;
        this.waitSearcher = waitSearcher;
        this.softCommit = softCommit;
        this.tupleSource = tupleSource;
    }

    @Override
    public void open() throws IOException {
        this.tupleSource.open();
        if (this.clientCache == null) {
            this.doCloseCache = true;
            this.clientCache = new SolrClientCache();
        } else {
            this.doCloseCache = false;
        }
        this.docsSinceCommit = 0L;
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this.tupleSource.read();
        if (tuple.EOF) {
            if (this.docsSinceCommit > 0L) {
                this.sendCommit();
            }
        } else {
            this.docsSinceCommit = tuple.getFields().containsKey(UpdateStream.BATCH_INDEXED_FIELD_NAME) && this.isInteger(tuple.getString(UpdateStream.BATCH_INDEXED_FIELD_NAME)) ? (this.docsSinceCommit += (long)Integer.parseInt(tuple.getString(UpdateStream.BATCH_INDEXED_FIELD_NAME))) : ++this.docsSinceCommit;
            if (this.commitBatchSize > 0 && this.docsSinceCommit >= (long)this.commitBatchSize) {
                this.sendCommit();
            }
        }
        return tuple;
    }

    private boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.doCloseCache) {
            this.clientCache.close();
        }
        this.tupleSource.close();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.tupleSource.getStreamSort();
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> sourceList = new ArrayList<TupleStream>(1);
        sourceList.add(this.tupleSource);
        return sourceList;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("batchSize", Integer.toString(this.commitBatchSize)));
        expression.addParameter(new StreamExpressionNamedParameter("waitFlush", Boolean.toString(this.waitFlush)));
        expression.addParameter(new StreamExpressionNamedParameter("waitSearcher", Boolean.toString(this.waitSearcher)));
        expression.addParameter(new StreamExpressionNamedParameter("softCommit", Boolean.toString(this.softCommit)));
        if (includeStreams) {
            if (!(this.tupleSource instanceof Expressible)) throw new IOException("This CommitStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.tupleSource)).toExpression(factory));
            return expression;
        } else {
            expression.addParameter("<stream>");
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        explanation.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        explanation.setImplementingClass("Solr/Lucene");
        explanation.setExpressionType("datastore");
        explanation.setExpression("Commit into " + this.collection);
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId().toString());
        child.setFunctionName(String.format(Locale.ROOT, factory.getFunctionName(this.getClass()), new Object[0]));
        child.setImplementingClass(this.getClass().getName());
        child.setExpressionType("stream-decorator");
        child.setExpression(this.toExpression(factory, false).toString());
        child.addChild(this.tupleSource.toExplanation(factory));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        if (null != context.getSolrClientCache()) {
            this.clientCache = context.getSolrClientCache();
        }
        this.tupleSource.setStreamContext(context);
    }

    private String findZkHost(StreamFactory factory, String collectionName, StreamExpression expression) {
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == zkHostExpression) {
            String zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                return factory.getDefaultZkHost();
            }
            return zkHost;
        }
        if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            return ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        return null;
    }

    private void sendCommit() throws IOException {
        try {
            this.clientCache.getCloudSolrClient(this.zkHost).commit(this.collection, this.waitFlush, this.waitSearcher, this.softCommit);
        }
        catch (IOException | SolrServerException e) {
            log.warn(String.format(Locale.ROOT, "Unable to commit documents to collection '%s' due to unexpected error.", this.collection), e);
            String className = e.getClass().getName();
            String message = e.getMessage();
            throw new IOException(String.format(Locale.ROOT, "Unexpected error when committing documents to collection %s- %s:%s", this.collection, className, message));
        }
    }
}

