/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.oauth.OAuthMessage;
import org.apache.shindig.auth.OAuthUtil;

class OAuthProtocolException
extends Exception {
    private static Set<String> fatalProblems = ImmutableSet.of((Object[])new String[]{"version_rejected", "signature_method_rejected", "consumer_key_unknown", "consumer_key_rejected", "timestamp_refused"});
    private static Set<String> temporaryProblems = ImmutableSet.of((Object)"consumer_key_refused");
    private static Set<String> extensionProblems = ImmutableSet.of((Object)"access_token_expired");
    private final boolean canRetry;
    private final boolean startFromScratch;
    private final boolean canExtend;
    private final String problemCode;

    public OAuthProtocolException(int status, OAuthMessage reply) {
        String problem = OAuthUtil.getParameter((OAuthMessage)reply, (String)"oauth_problem");
        if (problem == null) {
            throw new IllegalArgumentException("No problem reported for OAuthProtocolException");
        }
        this.problemCode = problem;
        if (fatalProblems.contains(problem)) {
            this.startFromScratch = true;
            this.canRetry = false;
            this.canExtend = false;
        } else if (temporaryProblems.contains(problem)) {
            this.startFromScratch = false;
            this.canRetry = false;
            this.canExtend = false;
        } else if (extensionProblems.contains(problem)) {
            this.startFromScratch = false;
            this.canRetry = true;
            this.canExtend = true;
        } else {
            if (status == 401) {
                this.startFromScratch = true;
                this.canRetry = true;
            } else {
                this.startFromScratch = false;
                this.canRetry = false;
            }
            this.canExtend = false;
        }
    }

    public OAuthProtocolException(int status) {
        if (status == 401) {
            this.startFromScratch = true;
            this.canRetry = true;
        } else {
            this.startFromScratch = false;
            this.canRetry = false;
        }
        this.canExtend = false;
        this.problemCode = null;
    }

    public boolean startFromScratch() {
        return this.startFromScratch;
    }

    public boolean canRetry() {
        return this.canRetry;
    }

    public boolean canExtend() {
        return this.canExtend;
    }

    public String getProblemCode() {
        return this.problemCode;
    }
}

