/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.impl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.UnaryOperationExpression;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.operator.common.SQLExtensionOperatorTable;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class UnaryOperationExpressionConverter {
    private static final Map<String, SqlOperator> REGISTRY = new CaseInsensitiveMap();

    private static void register() {
        UnaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.UNARY_PLUS);
        UnaryOperationExpressionConverter.register((SqlOperator)SqlStdOperatorTable.UNARY_MINUS);
        UnaryOperationExpressionConverter.register((SqlOperator)SQLExtensionOperatorTable.TILDE);
    }

    private static void register(SqlOperator sqlOperator) {
        REGISTRY.put(sqlOperator.getName(), sqlOperator);
    }

    public static Optional<SqlNode> convert(UnaryOperationExpression segment) {
        SqlOperator operator = UnaryOperationExpressionConverter.convertOperator(segment);
        List<SqlNode> sqlNodes = UnaryOperationExpressionConverter.convertSqlNodes(segment);
        return Optional.of(new SqlBasicCall(operator, sqlNodes, SqlParserPos.ZERO));
    }

    private static SqlOperator convertOperator(UnaryOperationExpression segment) {
        String operator = segment.getOperator();
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: %s", (Object)operator);
        return REGISTRY.get(operator);
    }

    private static List<SqlNode> convertSqlNodes(UnaryOperationExpression segment) {
        SqlNode expression = ExpressionConverter.convert(segment.getExpression()).orElseThrow(IllegalStateException::new);
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        result.add(expression);
        return result;
    }

    @Generated
    private UnaryOperationExpressionConverter() {
    }

    static {
        UnaryOperationExpressionConverter.register();
    }
}

