/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection.transaction;

import lombok.Generated;

public final class TransactionConnectionContext
implements AutoCloseable {
    private volatile String transactionType;
    private volatile boolean inTransaction;
    private volatile long beginMills;
    private volatile String readWriteSplitReplicaRoute;

    public void beginTransaction(String transactionType) {
        this.transactionType = transactionType;
        this.inTransaction = true;
    }

    public boolean isInDistributedTransaction() {
        return this.inTransaction && ("XA".equals(this.transactionType) || "BASE".equals(this.transactionType));
    }

    @Override
    public void close() {
        this.inTransaction = false;
        this.beginMills = 0L;
        this.readWriteSplitReplicaRoute = null;
    }

    @Generated
    public String getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Generated
    public long getBeginMills() {
        return this.beginMills;
    }

    @Generated
    public String getReadWriteSplitReplicaRoute() {
        return this.readWriteSplitReplicaRoute;
    }

    @Generated
    public void setBeginMills(long beginMills) {
        this.beginMills = beginMills;
    }

    @Generated
    public void setReadWriteSplitReplicaRoute(String readWriteSplitReplicaRoute) {
        this.readWriteSplitReplicaRoute = readWriteSplitReplicaRoute;
    }
}

