/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.util.Enumeration;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

public class ContextInitParameterTest
extends AbstractReflectivePortletTest {
    private static final String TEST_PARAM_NAME = "test-parameter-name";
    private static final String TEST_PARAM_VALUE = "test-parameter-val";

    protected TestResult checkEnumerationContainsNames(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that the expected init parameter name exists in the portlet context's init parameters.");
        result.setSpecPLT("10.3.1");
        boolean found = false;
        Enumeration en = context.getInitParameterNames();
        while (!found && en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!TEST_PARAM_NAME.equals(name)) continue;
            found = true;
        }
        if (found) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Expected init parameter 'test-parameter-name' not found in portlet context.");
        }
        return result;
    }

    protected TestResult checkGetInitParameter(PortletContext context) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that init parameters are retrieveable.");
        result.setSpecPLT("10.3.1");
        String value = context.getInitParameter(TEST_PARAM_NAME);
        if (TEST_PARAM_VALUE.equals(value)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"init parameter", (Object)value, (Object)TEST_PARAM_VALUE, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkGetContextFromSession(PortletSession session) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that the PortletContext can be retrieved from the portlet session.");
        PortletContext context = session.getPortletContext();
        if (context != null) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("Fail to retrieve PortletContext from PortletSession: null returned.");
        }
        return result;
    }
}

