/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import javax.portlet.PortletSession;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;

public class AppScopedSessionAttributeTest
extends AbstractReflectivePortletTest {
    private static final String BOGUS_KEY = "org.apache.pluto.testsuite.BOGUS_KEY";
    private static final String KEY = "org.apache.pluto.testsuite.KEY";
    private static final String VALUE = "VALUE";

    protected TestResult checkGetEmptyAppScopedAttribute(PortletSession session) {
        TestResult result = new TestResult();
        result.setDescription("Retrieve an attribute that has not been set in the session's application scope and ensure it's value is null.");
        result.setSpecPLT("15.3");
        Object value = session.getAttribute(BOGUS_KEY, 1);
        if (value == null) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"session attribute", (Object)value, null, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkSetAppScopedAttribute(PortletSession session) {
        TestResult result = new TestResult();
        result.setDescription("Set an application scoped session attribute and ensure it's retrievable.");
        result.setSpecPLT("15.3");
        session.setAttribute(KEY, (Object)VALUE, 1);
        Object value = session.getAttribute(KEY, 1);
        if (VALUE.equals(value)) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"session attribute", (Object)value, (Object)VALUE, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkRemoveAppScopedAttribute(PortletSession session) {
        TestResult result = new TestResult();
        result.setDescription("Remove an application scoped session attribute and ensure it's null.");
        result.setSpecPLT("15.3");
        session.setAttribute(KEY, (Object)VALUE, 1);
        session.removeAttribute(KEY, 1);
        Object value = session.getAttribute(KEY, 1);
        if (value == null) {
            result.setReturnCode(2);
        } else {
            TestUtils.failOnAssertion((String)"session attribute", (Object)value, null, (TestResult)result);
        }
        return result;
    }
}

