/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.temp;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.CryptoFunctions;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.TempFile;

public final class AesZipFileZipEntrySource
implements ZipEntrySource {
    private static final Logger LOG = LogManager.getLogger(AesZipFileZipEntrySource.class);
    private static final String PADDING = "PKCS5Padding";
    private final File tmpFile;
    private final ZipFile zipFile;
    private final Cipher ci;
    private boolean closed;

    private AesZipFileZipEntrySource(File tmpFile, Cipher ci) throws IOException {
        this.tmpFile = tmpFile;
        this.zipFile = new ZipFile(tmpFile);
        this.ci = ci;
        this.closed = false;
    }

    @Override
    public Enumeration<? extends ZipArchiveEntry> getEntries() {
        return this.zipFile.getEntries();
    }

    @Override
    public ZipArchiveEntry getEntry(String path) {
        return this.zipFile.getEntry(path);
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        InputStream is = this.zipFile.getInputStream(entry);
        return new CipherInputStream(is, this.ci);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.zipFile.close();
            if (!this.tmpFile.delete()) {
                LOG.atWarn().log("{} can't be removed (or was already removed.", (Object)this.tmpFile.getAbsolutePath());
            }
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public static AesZipFileZipEntrySource createZipEntrySource(InputStream is) throws IOException {
        SecureRandom sr = new SecureRandom();
        byte[] ivBytes = new byte[16];
        byte[] keyBytes = new byte[16];
        sr.nextBytes(ivBytes);
        sr.nextBytes(keyBytes);
        File tmpFile = TempFile.createTempFile((String)"protectedXlsx", (String)".zip");
        AesZipFileZipEntrySource.copyToFile(is, tmpFile, keyBytes, ivBytes);
        IOUtils.closeQuietly((Closeable)is);
        return AesZipFileZipEntrySource.fileToSource(tmpFile, keyBytes, ivBytes);
    }

    private static void copyToFile(InputStream is, File tmpFile, byte[] keyBytes, byte[] ivBytes) throws IOException {
        SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, CipherAlgorithm.aes128.jceId);
        Cipher ciEnc = CryptoFunctions.getCipher((Key)skeySpec, (CipherAlgorithm)CipherAlgorithm.aes128, (ChainingMode)ChainingMode.cbc, (byte[])ivBytes, (int)1, (String)PADDING);
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(is);
             FileOutputStream fos = new FileOutputStream(tmpFile);
             ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)fos);){
            ZipArchiveEntry ze;
            while ((ze = zis.getNextZipEntry()) != null) {
                ZipArchiveEntry zeNew = new ZipArchiveEntry(ze.getName());
                zeNew.setComment(ze.getComment());
                zeNew.setExtra(ze.getExtra());
                zeNew.setTime(ze.getTime());
                zos.putArchiveEntry((ArchiveEntry)zeNew);
                FilterOutputStream fos2 = new FilterOutputStream((OutputStream)zos){

                    @Override
                    public void close() {
                    }
                };
                CipherOutputStream cos = new CipherOutputStream(fos2, ciEnc);
                IOUtils.copy((InputStream)zis, (OutputStream)cos);
                cos.close();
                fos2.close();
                zos.closeArchiveEntry();
            }
        }
    }

    private static AesZipFileZipEntrySource fileToSource(File tmpFile, byte[] keyBytes, byte[] ivBytes) throws IOException {
        SecretKeySpec skeySpec = new SecretKeySpec(keyBytes, CipherAlgorithm.aes128.jceId);
        Cipher ciDec = CryptoFunctions.getCipher((Key)skeySpec, (CipherAlgorithm)CipherAlgorithm.aes128, (ChainingMode)ChainingMode.cbc, (byte[])ivBytes, (int)2, (String)PADDING);
        return new AesZipFileZipEntrySource(tmpFile, ciDec);
    }
}

