/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.contrib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HSSFCellUtil {
    private static HashMap unicodeMappings = new HashMap();

    public static HSSFRow getRow(int rowCounter, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(rowCounter);
        if (row == null) {
            row = sheet.createRow(rowCounter);
        }
        return row;
    }

    public static HSSFCell getCell(HSSFRow row, int column) {
        HSSFCell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell((short)column);
        }
        return cell;
    }

    public static HSSFCell createCell(HSSFRow row, int column, String value, HSSFCellStyle style) {
        HSSFCell cell = HSSFCellUtil.getCell(row, column);
        cell.setCellValue(new HSSFRichTextString(value));
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public static HSSFCell createCell(HSSFRow row, int column, String value) {
        return HSSFCellUtil.createCell(row, column, value, null);
    }

    public static void setAlignment(HSSFCell cell, HSSFWorkbook workbook, short align) throws NestableException {
        HSSFCellUtil.setCellStyleProperty(cell, workbook, "alignment", new Short(align));
    }

    public static void setFont(HSSFCell cell, HSSFWorkbook workbook, HSSFFont font) throws NestableException {
        HSSFCellUtil.setCellStyleProperty(cell, workbook, "font", font);
    }

    public static void setCellStyleProperty(HSSFCell cell, HSSFWorkbook workbook, String propertyName, Object propertyValue) throws NestableException {
        try {
            HSSFCellStyle originalStyle = cell.getCellStyle();
            HSSFCellStyle newStyle = null;
            Map values = PropertyUtils.describe((Object)originalStyle);
            values.put(propertyName, propertyValue);
            values.remove("index");
            short numberCellStyles = workbook.getNumCellStyles();
            for (short i = 0; i < numberCellStyles; i = (short)(i + 1)) {
                HSSFCellStyle wbStyle = workbook.getCellStyleAt(i);
                Map wbStyleMap = PropertyUtils.describe((Object)wbStyle);
                wbStyleMap.remove("index");
                if (!((Object)wbStyleMap).equals(values)) continue;
                newStyle = wbStyle;
                break;
            }
            if (newStyle == null) {
                newStyle = workbook.createCellStyle();
                newStyle.setFont(workbook.getFontAt(originalStyle.getFontIndex()));
                PropertyUtils.copyProperties((Object)newStyle, (Object)originalStyle);
                PropertyUtils.setProperty((Object)newStyle, (String)propertyName, (Object)propertyValue);
            }
            cell.setCellStyle(newStyle);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NestableException("Couldn't setCellStyleProperty.", (Throwable)e);
        }
    }

    public static HSSFCell translateUnicodeValues(HSSFCell cell) {
        String s = cell.getRichStringCellValue().getString();
        boolean foundUnicode = false;
        Iterator i = unicodeMappings.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            if (s.toLowerCase().indexOf(key) == -1) continue;
            s = StringUtils.replace((String)s, (String)key, (String)("" + entry.getValue().toString() + ""));
            foundUnicode = true;
        }
        if (foundUnicode) {
            cell.setEncoding((short)1);
            cell.setCellValue(s);
        }
        return cell;
    }

    static {
        unicodeMappings.put("&alpha;", "\u03b1");
        unicodeMappings.put("&beta;", "\u03b2");
        unicodeMappings.put("&gamma;", "\u03b3");
        unicodeMappings.put("&delta;", "\u03b4");
        unicodeMappings.put("&epsilon;", "\u03b5");
        unicodeMappings.put("&zeta;", "\u03b6");
        unicodeMappings.put("&eta;", "\u03b7");
        unicodeMappings.put("&theta;", "\u03b8");
        unicodeMappings.put("&iota;", "\u03b9");
        unicodeMappings.put("&kappa;", "\u03ba");
        unicodeMappings.put("&lambda;", "\u03bb");
        unicodeMappings.put("&mu;", "\u03bc");
        unicodeMappings.put("&nu;", "\u03bd");
        unicodeMappings.put("&xi;", "\u03be");
        unicodeMappings.put("&omicron;", "\u03bf");
    }
}

