/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletContainerFactory;
import org.apache.pluto.RequiredContainerServices;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.springframework.web.context.WebApplicationContext;

public class PortalStartupListener
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$PortalStartupListener == null ? (class$org$apache$pluto$driver$PortalStartupListener = PortalStartupListener.class$("org.apache.pluto.driver.PortalStartupListener")) : class$org$apache$pluto$driver$PortalStartupListener));
    private static final String CONTAINER_KEY = "portletContainer";
    private static final String DRIVER_CONFIG_KEY = "driverConfig";
    private static final String ADMIN_CONFIG_KEY = "driverAdminConfig";
    static /* synthetic */ Class class$org$apache$pluto$driver$PortalStartupListener;

    public void contextInitialized(ServletContextEvent event) {
        LOG.info((Object)"Starting up Pluto Portal Driver. . .");
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext springContext = (WebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        LOG.debug((Object)" [1a] Loading DriverConfiguration. . . ");
        DriverConfiguration driverConfiguration = (DriverConfiguration)springContext.getBean("DriverConfiguration");
        driverConfiguration.init(servletContext);
        LOG.debug((Object)" [1b] Registering DriverConfiguration. . .");
        servletContext.setAttribute(DRIVER_CONFIG_KEY, (Object)driverConfiguration);
        LOG.debug((Object)" [2a] Loading Optional AdminConfiguration. . .");
        AdminConfiguration adminConfiguration = (AdminConfiguration)springContext.getBean("AdminConfiguration");
        if (adminConfiguration != null) {
            LOG.debug((Object)" [2b] Registering Optional AdminConfiguration");
            servletContext.setAttribute(ADMIN_CONFIG_KEY, (Object)adminConfiguration);
        } else {
            LOG.info((Object)"Optional AdminConfiguration not found. Ignoring.");
        }
        this.initContainer(servletContext);
        LOG.info((Object)"********** Pluto Portal Driver Started **********\n\n");
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Shutting down Pluto Portal Driver...");
        }
        this.destroyContainer(servletContext);
        this.destroyAdminConfiguration(servletContext);
        this.destroyDriverConfiguration(servletContext);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"********** Pluto Portal Driver Shut Down **********\n\n");
        }
    }

    private void initContainer(ServletContext servletContext) {
        WebApplicationContext springContext = (WebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute(DRIVER_CONFIG_KEY);
        try {
            LOG.info((Object)"Initializing Portlet Container. . .");
            LOG.debug((Object)" [1] Loading RequiredContainerServices. . .");
            RequiredContainerServices required = (RequiredContainerServices)springContext.getBean("RequiredContainerServices");
            LOG.debug((Object)" [2] Loading OptionalContainerServices. . .");
            OptionalContainerServices optional = (OptionalContainerServices)springContext.getBean("OptionalContainerServices");
            LOG.debug((Object)" [3] Creating portlet container...");
            PortletContainerFactory factory = PortletContainerFactory.getInstance();
            PortletContainer container = factory.createContainer(driverConfig.getContainerName(), required, optional);
            LOG.debug((Object)" [4] Initializing portlet container...");
            container.init(servletContext);
            servletContext.setAttribute(CONTAINER_KEY, (Object)container);
            LOG.info((Object)"Pluto portlet container started.");
        }
        catch (DriverConfigurationException ex) {
            LOG.error((Object)("Unable to retrieve driver configuration due to configuration error: " + ex.getMessage()), (Throwable)ex);
        }
        catch (PortletContainerException ex) {
            LOG.error((Object)("Unable to start up portlet container: " + ex.getMessage()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContainer(ServletContext servletContext) {
        PortletContainer container;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Shutting down Pluto Portal Driver...");
        }
        if ((container = (PortletContainer)servletContext.getAttribute(CONTAINER_KEY)) != null) {
            try {
                container.destroy();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Pluto Portal Driver shut down.");
                }
            }
            catch (PortletContainerException ex) {
                LOG.error((Object)("Unable to shut down portlet container: " + ex.getMessage()), (Throwable)ex);
            }
            finally {
                servletContext.removeAttribute(CONTAINER_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyDriverConfiguration(ServletContext servletContext) {
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute(DRIVER_CONFIG_KEY);
        if (driverConfig != null) {
            try {
                driverConfig.destroy();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Pluto Portal Driver Config destroyed.");
                }
            }
            catch (DriverConfigurationException ex) {
                LOG.error((Object)("Unable to destroy portal driver config: " + ex.getMessage()), (Throwable)ex);
            }
            finally {
                servletContext.removeAttribute(DRIVER_CONFIG_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdminConfiguration(ServletContext servletContext) {
        AdminConfiguration adminConfig = (AdminConfiguration)servletContext.getAttribute(ADMIN_CONFIG_KEY);
        if (adminConfig != null) {
            try {
                adminConfig.destroy();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Pluto Portal Admin Config destroyed.");
                }
            }
            catch (DriverConfigurationException ex) {
                LOG.error((Object)("Unable to destroy portal admin config: " + ex.getMessage()), (Throwable)ex);
            }
            finally {
                servletContext.removeAttribute(ADMIN_CONFIG_KEY);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

