/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.url.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLParser;
import org.apache.pluto.driver.url.impl.RelativePortalURLImpl;
import org.apache.pluto.util.StringUtils;

public class PortalURLParserImpl
implements PortalURLParser {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$url$impl$PortalURLParserImpl == null ? (class$org$apache$pluto$driver$url$impl$PortalURLParserImpl = PortalURLParserImpl.class$("org.apache.pluto.driver.url.impl.PortalURLParserImpl")) : class$org$apache$pluto$driver$url$impl$PortalURLParserImpl));
    private static final PortalURLParser PARSER = new PortalURLParserImpl();
    private static final String PREFIX = "__";
    private static final String DELIM = "_";
    private static final String PORTLET_ID = "pd";
    private static final String ACTION = "ac";
    private static final String RENDER_PARAM = "rp";
    private static final String WINDOW_STATE = "ws";
    private static final String PORTLET_MODE = "pm";
    private static final String VALUE_DELIM = "0x0";
    private static final String[][] ENCODINGS = new String[][]{{"_", "0x1"}, {".", "0x2"}, {"/", "0x3"}, {"\r", "0x4"}, {"\n", "0x5"}, {"<", "0x6"}, {">", "0x7"}, {" ", "0x8"}, {"#", "0x9"}};
    static /* synthetic */ Class class$org$apache$pluto$driver$url$impl$PortalURLParserImpl;

    private PortalURLParserImpl() {
    }

    public static PortalURLParser getParser() {
        return PARSER;
    }

    public PortalURL parse(HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing URL: " + request.getRequestURI()));
        }
        String contextPath = request.getContextPath();
        String servletName = request.getServletPath();
        RelativePortalURLImpl portalURL = new RelativePortalURLImpl(contextPath, servletName);
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            if (servletName.indexOf(".jsp") != -1 && !servletName.endsWith(".jsp")) {
                int idx = servletName.indexOf(".jsp") + ".jsp".length();
                pathInfo = servletName.substring(idx);
                servletName = servletName.substring(0, idx);
                portalURL = new RelativePortalURLImpl(contextPath, servletName);
            } else {
                return portalURL;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing request pathInfo: " + pathInfo));
        }
        StringBuffer renderPath = new StringBuffer();
        StringTokenizer st = new StringTokenizer(pathInfo, "/", false);
        while (st.hasMoreTokens()) {
            PortalURLParameter param;
            String[] decoded;
            String token = st.nextToken();
            if (!token.startsWith(PREFIX)) {
                renderPath.append('/').append(token);
                continue;
            }
            if (token.startsWith("__ac")) {
                portalURL.setActionWindow(this.decodeControlParameter(token)[0]);
                continue;
            }
            if (token.startsWith("__ws")) {
                decoded = this.decodeControlParameter(token);
                portalURL.setWindowState(decoded[0], new WindowState(decoded[1]));
                continue;
            }
            if (token.startsWith("__pm")) {
                decoded = this.decodeControlParameter(token);
                portalURL.setPortletMode(decoded[0], new PortletMode(decoded[1]));
                continue;
            }
            String value = null;
            if (st.hasMoreTokens()) {
                value = st.nextToken();
            }
            if ((param = this.decodeParameter(token, value)) == null) continue;
            portalURL.addParameter(param);
        }
        if (renderPath.length() > 0) {
            portalURL.setRenderPath(renderPath.toString());
        }
        return portalURL;
    }

    public String toString(PortalURL portalURL) {
        Map.Entry entry;
        StringBuffer buffer = new StringBuffer();
        buffer.append(portalURL.getServletPath().startsWith("/") ? "" : "/").append(portalURL.getServletPath());
        if (portalURL.getRenderPath() != null) {
            buffer.append("/").append(portalURL.getRenderPath());
        }
        if (portalURL.getActionWindow() != null) {
            buffer.append("/");
            buffer.append(PREFIX).append(ACTION).append(this.encodeCharacters(portalURL.getActionWindow()));
        }
        Iterator it = portalURL.getPortletModes().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            buffer.append("/").append(this.encodeControlParameter(PORTLET_MODE, entry.getKey().toString(), entry.getValue().toString()));
        }
        it = portalURL.getWindowStates().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            buffer.append("/").append(this.encodeControlParameter(WINDOW_STATE, entry.getKey().toString(), entry.getValue().toString()));
        }
        StringBuffer query = new StringBuffer("?");
        boolean firstParam = true;
        Iterator it2 = portalURL.getParameters().iterator();
        while (it2.hasNext()) {
            String valueString;
            PortalURLParameter param = (PortalURLParameter)it2.next();
            if (portalURL.getActionWindow() != null && portalURL.getActionWindow().equals(param.getWindowId())) {
                for (int i = 0; i < param.getValues().length; ++i) {
                    if (firstParam) {
                        firstParam = false;
                    } else {
                        query.append("&");
                    }
                    query.append(this.encodeQueryParam(param.getName())).append("=").append(this.encodeQueryParam(param.getValues()[i]));
                }
                continue;
            }
            if (param.getValues() == null || param.getValues().length <= 0 || (valueString = this.encodeMultiValues(param.getValues())).length() <= 0) continue;
            buffer.append("/").append(this.encodeControlParameter(RENDER_PARAM, param.getWindowId(), param.getName()));
            buffer.append("/").append(valueString);
        }
        if (query.length() > 1) {
            return buffer.append(query).toString();
        }
        return buffer.toString();
    }

    private String encodeQueryParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeControlParameter(String type, String windowId, String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREFIX).append(type).append(this.encodeCharacters(windowId)).append(DELIM).append(name);
        return buffer.toString();
    }

    private String encodeMultiValues(String[] values) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            buffer.append(values[i] != null ? values[i] : "");
            if (i + 1 >= values.length) continue;
            buffer.append(VALUE_DELIM);
        }
        return this.encodeCharacters(buffer.toString());
    }

    private String encodeCharacters(String string) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            string = StringUtils.replace((String)string, (String)ENCODINGS[i][0], (String)ENCODINGS[i][1]);
        }
        return string;
    }

    private String[] decodeControlParameter(String control) {
        String[] valuePair = new String[2];
        int index = (control = control.substring("__pd".length())).indexOf(DELIM);
        if (index >= 0) {
            valuePair[0] = control.substring(0, index);
            valuePair[0] = this.decodeCharacters(valuePair[0]);
            if (index + 1 <= control.length()) {
                valuePair[1] = control.substring(index + 1);
                valuePair[1] = this.decodeCharacters(valuePair[1]);
            } else {
                valuePair[1] = "";
            }
        } else {
            valuePair[0] = this.decodeCharacters(control);
        }
        return valuePair;
    }

    private PortalURLParameter decodeParameter(String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Decoding parameter: name=" + name + ", value=" + value));
        }
        if (name.length() < "__pd".length()) {
            return null;
        }
        String noPrefix = name.substring("__pd".length());
        String windowId = noPrefix.substring(0, noPrefix.indexOf(DELIM));
        String paramName = noPrefix.substring(noPrefix.indexOf(DELIM) + 1);
        windowId = this.decodeCharacters(windowId);
        if (value != null) {
            value = this.decodeCharacters(value);
        }
        String[] paramValues = value.split(VALUE_DELIM);
        return new PortalURLParameter(windowId, paramName, paramValues);
    }

    private String decodeCharacters(String string) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            string = StringUtils.replace((String)string, (String)ENCODINGS[i][1], (String)ENCODINGS[i][0]);
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

