/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.common.SecurityRoleRefDD;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.internal.PortletEntity;
import org.apache.pluto.internal.impl.PortletSessionImpl;
import org.apache.pluto.util.ArgumentUtility;
import org.apache.pluto.util.Enumerator;
import org.apache.pluto.util.NamespaceMapper;
import org.apache.pluto.util.StringManager;
import org.apache.pluto.util.StringUtils;
import org.apache.pluto.util.impl.NamespaceMapperImpl;

public abstract class PortletRequestImpl
extends HttpServletRequestWrapper
implements PortletRequest,
InternalPortletRequest {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$PortletRequestImpl == null ? (class$org$apache$pluto$internal$impl$PortletRequestImpl = PortletRequestImpl.class$("org.apache.pluto.internal.impl.PortletRequestImpl")) : class$org$apache$pluto$internal$impl$PortletRequestImpl));
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$impl$PortletRequestImpl == null ? (class$org$apache$pluto$internal$impl$PortletRequestImpl = PortletRequestImpl.class$("org.apache.pluto.internal.impl.PortletRequestImpl")) : class$org$apache$pluto$internal$impl$PortletRequestImpl).getPackage().getName());
    private PortletContainer container;
    private InternalPortletWindow internalPortletWindow;
    private PortletContext portletContext;
    private PortalContext portalContext;
    private PortletSession portletSession;
    private Vector contentTypes;
    private final NamespaceMapper mapper = new NamespaceMapperImpl();
    private boolean bodyAccessed = false;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletRequestImpl;

    public PortletRequestImpl(InternalPortletRequest internalPortletRequest) {
        this(internalPortletRequest.getPortletContainer(), internalPortletRequest.getInternalPortletWindow(), internalPortletRequest.getHttpServletRequest());
    }

    public PortletRequestImpl(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest) {
        super(servletRequest);
        this.container = container;
        this.internalPortletWindow = internalPortletWindow;
        this.portalContext = container.getRequiredContainerServices().getPortalContext();
    }

    public boolean isWindowStateAllowed(WindowState state) {
        Enumeration en = this.portalContext.getSupportedWindowStates();
        while (en.hasMoreElements()) {
            if (!en.nextElement().toString().equals(state.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletModeAllowed(PortletMode mode) {
        return this.isPortletModeAllowedByPortlet(mode) && this.isPortletModeAllowedByPortal(mode);
    }

    public PortletMode getPortletMode() {
        return this.internalPortletWindow.getPortletMode();
    }

    public WindowState getWindowState() {
        return this.internalPortletWindow.getWindowState();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        int maxInactiveInterval;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retreiving portlet session (create=" + create + ")"));
        }
        if (this.portletContext == null) {
            throw new IllegalStateException(EXCEPTIONS.getString("error.session.illegalState"));
        }
        HttpSession httpSession = this.getHttpServletRequest().getSession(create);
        if (httpSession != null && (maxInactiveInterval = httpSession.getMaxInactiveInterval()) >= 0) {
            long maxInactiveTime = (long)httpSession.getMaxInactiveInterval() * 1000L;
            long currentInactiveTime = System.currentTimeMillis() - httpSession.getLastAccessedTime();
            if (currentInactiveTime > maxInactiveTime) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The underlying HttpSession is expired and should be invalidated.");
                }
                httpSession.invalidate();
                httpSession = this.getHttpServletRequest().getSession(create);
            }
        }
        if (httpSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The underlying HttpSession is not available: no session will be returned.");
            }
            return null;
        }
        if (this.portletSession == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Creating new portlet session...");
            }
            this.portletSession = new PortletSessionImpl(this.portletContext, this.internalPortletWindow, httpSession);
        }
        return this.portletSession;
    }

    public String getProperty(String name) throws IllegalArgumentException {
        String[] properties;
        Map propertyMap;
        ArgumentUtility.validateNotNull("propertyName", name);
        String property = this.getHttpServletRequest().getHeader(name);
        if (property == null && (propertyMap = this.container.getRequiredContainerServices().getPortalCallbackService().getRequestProperties(this.getHttpServletRequest(), this.internalPortletWindow)) != null && (properties = (String[])propertyMap.get(name)) != null && properties.length > 0) {
            property = properties[0];
        }
        return property;
    }

    public Enumeration getProperties(String name) {
        String[] properties;
        Map map;
        ArgumentUtility.validateNotNull("propertyName", name);
        HashSet v = new HashSet();
        Enumeration props = this.getHttpServletRequest().getHeaders(name);
        if (props != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        if ((map = this.container.getRequiredContainerServices().getPortalCallbackService().getRequestProperties(this.getHttpServletRequest(), this.internalPortletWindow)) != null && (properties = (String[])map.get(name)) != null) {
            for (int i = 0; i < properties.length; ++i) {
                v.add(properties[i]);
            }
        }
        return new Enumerator(v.iterator());
    }

    public Enumeration getPropertyNames() {
        Enumeration props;
        HashSet<Object> v = new HashSet<Object>();
        Map map = this.container.getRequiredContainerServices().getPortalCallbackService().getRequestProperties(this.getHttpServletRequest(), this.internalPortletWindow);
        if (map != null) {
            v.addAll(map.keySet());
        }
        if ((props = this.getHttpServletRequest().getHeaderNames()) != null) {
            while (props.hasMoreElements()) {
                v.add(props.nextElement());
            }
        }
        return new Enumerator(v.iterator());
    }

    public PortalContext getPortalContext() {
        return this.container.getRequiredContainerServices().getPortalContext();
    }

    public String getAuthType() {
        return this.getHttpServletRequest().getAuthType();
    }

    public String getContextPath() {
        String contextPath = this.internalPortletWindow.getContextPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return contextPath;
    }

    public String getRemoteUser() {
        return this.getHttpServletRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.getHttpServletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String roleName) {
        PortletEntity entity = this.internalPortletWindow.getPortletEntity();
        PortletDD def = entity.getPortletDefinition();
        SecurityRoleRefDD ref = null;
        Iterator refs = def.getSecurityRoleRefs().iterator();
        while (refs.hasNext()) {
            SecurityRoleRefDD r = (SecurityRoleRefDD)refs.next();
            if (!r.getRoleName().equals(roleName)) continue;
            ref = r;
            break;
        }
        String link = ref != null && ref.getRoleLink() != null ? ref.getRoleLink() : roleName;
        return this.getHttpServletRequest().isUserInRole(link);
    }

    public Object getAttribute(String name) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if ("javax.portlet.userinfo".equals(name)) {
            return this.createUserInfoMap();
        }
        String encodedName = this.isNameReserved(name) ? name : this.mapper.encode(this.internalPortletWindow.getId(), name);
        Object attribute = this.getHttpServletRequest().getAttribute(encodedName);
        if (attribute == null) {
            attribute = this.getHttpServletRequest().getAttribute(name);
        }
        return attribute;
    }

    public Enumeration getAttributeNames() {
        Enumeration attributes = this.getHttpServletRequest().getAttributeNames();
        Vector<String> portletAttributes = new Vector<String>();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            String portletAttribute = this.isNameReserved(attribute) ? attribute : this.mapper.decode(this.internalPortletWindow.getId(), attribute);
            if (portletAttribute == null) continue;
            portletAttributes.add(portletAttribute);
        }
        return portletAttributes.elements();
    }

    public Map createUserInfoMap() {
        HashMap userInfoMap = new HashMap();
        try {
            PortletAppDD dd = this.container.getOptionalContainerServices().getPortletRegistryService().getPortletApplicationDescriptor(this.internalPortletWindow.getContextPath());
            Map allMap = this.container.getOptionalContainerServices().getUserInfoService().getUserInfo(this, this.internalPortletWindow);
            Iterator i = dd.getUserAttributes().iterator();
            while (i.hasNext()) {
                UserAttributeDD udd = (UserAttributeDD)i.next();
                userInfoMap.put(udd.getName(), allMap.get(udd.getName()));
            }
        }
        catch (PortletContainerException e) {
            LOG.warn((Object)("Unable to retrieve user attribute map for user " + this.getRemoteUser() + ".  Returning null."));
            return null;
        }
        return Collections.unmodifiableMap(userInfoMap);
    }

    public String getParameter(String name) {
        ArgumentUtility.validateNotNull("parameterName", name);
        String[] values = (String[])this.baseGetParameterMap().get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.baseGetParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        ArgumentUtility.validateNotNull("parameterName", name);
        String[] values = (String[])this.baseGetParameterMap().get(name);
        if (values != null) {
            values = StringUtils.copy(values);
        }
        return values;
    }

    public Map getParameterMap() {
        return StringUtils.copyParameters(this.baseGetParameterMap());
    }

    public boolean isSecure() {
        return this.getHttpServletRequest().isSecure();
    }

    public void setAttribute(String name, Object value) {
        String encodedName;
        ArgumentUtility.validateNotNull("attributeName", name);
        String string = encodedName = this.isNameReserved(name) ? name : this.mapper.encode(this.internalPortletWindow.getId(), name);
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.getHttpServletRequest().setAttribute(encodedName, value);
        }
    }

    public void removeAttribute(String name) {
        ArgumentUtility.validateNotNull("attributeName", name);
        String encodedName = this.isNameReserved(name) ? name : this.mapper.encode(this.internalPortletWindow.getId(), name);
        this.getHttpServletRequest().removeAttribute(encodedName);
    }

    public String getRequestedSessionId() {
        return this.getHttpServletRequest().getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ***** IsRequestedSessionIdValid? " + this.getHttpServletRequest().isRequestedSessionIdValid()));
        }
        return this.getHttpServletRequest().isRequestedSessionIdValid();
    }

    public String getResponseContentType() {
        Enumeration enumeration = this.getResponseContentTypes();
        if (enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return "text/html";
    }

    public Enumeration getResponseContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new Vector();
            PortletDD dd = this.internalPortletWindow.getPortletEntity().getPortletDefinition();
            Iterator supports = dd.getSupports().iterator();
            while (supports.hasNext()) {
                SupportsDD sup = (SupportsDD)supports.next();
                this.contentTypes.add(sup.getMimeType());
            }
            if (this.contentTypes.size() < 1) {
                this.contentTypes.add("text/html");
            }
        }
        return this.contentTypes.elements();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public Enumeration getLocales() {
        return this.getHttpServletRequest().getLocales();
    }

    public String getScheme() {
        return this.getHttpServletRequest().getScheme();
    }

    public String getServerName() {
        return this.getHttpServletRequest().getServerName();
    }

    public int getServerPort() {
        return this.getHttpServletRequest().getServerPort();
    }

    protected Map baseGetParameterMap() {
        this.bodyAccessed = true;
        return this.getHttpServletRequest().getParameterMap();
    }

    protected void setBodyAccessed() {
        this.bodyAccessed = true;
    }

    public InternalPortletWindow getInternalPortletWindow() {
        return this.internalPortletWindow;
    }

    public PortletContainer getPortletContainer() {
        return this.container;
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public void init(PortletContext portletContext, HttpServletRequest req) {
        this.portletContext = portletContext;
        this.setRequest((ServletRequest)req);
    }

    public void release() {
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        BufferedReader reader = this.getHttpServletRequest().getReader();
        this.bodyAccessed = true;
        return reader;
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream stream = this.getHttpServletRequest().getInputStream();
        this.bodyAccessed = true;
        return stream;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.getHttpServletRequest().getRequestDispatcher(path);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.bodyAccessed) {
            throw new IllegalStateException("Cannot set character encoding after HTTP body is accessed.");
        }
        super.setCharacterEncoding(encoding);
    }

    private boolean isNameReserved(String name) {
        return name.startsWith("java.") || name.startsWith("javax.");
    }

    private boolean isPortletModeAllowedByPortlet(PortletMode mode) {
        if (this.isPortletModeMandatory(mode)) {
            return true;
        }
        PortletDD dd = this.internalPortletWindow.getPortletEntity().getPortletDefinition();
        Iterator mimes = dd.getSupports().iterator();
        while (mimes.hasNext()) {
            Iterator modes = ((SupportsDD)mimes.next()).getPortletModes().iterator();
            while (modes.hasNext()) {
                String m = (String)modes.next();
                if (!m.equals(mode.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPortletModeAllowedByPortal(PortletMode mode) {
        Enumeration supportedModes = this.portalContext.getSupportedPortletModes();
        while (supportedModes.hasMoreElements()) {
            if (!supportedModes.nextElement().toString().equals(mode.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isPortletModeMandatory(PortletMode mode) {
        return PortletMode.VIEW.equals((Object)mode) || PortletMode.EDIT.equals((Object)mode) || PortletMode.HELP.equals((Object)mode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ PortletPreferences getPreferences();
}

