/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import org.apache.pdfbox.examples.signature.CMSProcessableInputStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.SignatureException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CreateSignature
implements SignatureInterface {
    private static BouncyCastleProvider provider = new BouncyCastleProvider();
    private PrivateKey privKey;
    private Certificate[] cert;
    private SignatureOptions options;

    public CreateSignature(KeyStore keystore, char[] pin) {
        try {
            Enumeration<String> aliases = keystore.aliases();
            String alias = null;
            if (!aliases.hasMoreElements()) {
                throw new RuntimeException("Could not find alias");
            }
            alias = aliases.nextElement();
            this.privKey = (PrivateKey)keystore.getKey(alias, pin);
            this.cert = keystore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            System.err.println("Could not extract private key.");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Unknown algorithm.");
            e.printStackTrace();
        }
    }

    public File signPDF(File document) throws IOException, COSVisitorException, SignatureException {
        int c;
        byte[] buffer = new byte[8192];
        if (document == null || !document.exists()) {
            new RuntimeException("Document for signing does not exist");
        }
        String name = document.getName();
        String substring = name.substring(0, name.lastIndexOf("."));
        File outputDocument = new File(document.getParent(), substring + "_signed.pdf");
        FileInputStream fis = new FileInputStream(document);
        FileOutputStream fos = new FileOutputStream(outputDocument);
        while ((c = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, c);
        }
        fis.close();
        fis = new FileInputStream(outputDocument);
        PDDocument doc = PDDocument.load((File)document);
        PDSignature signature = new PDSignature();
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        signature.setName("signer name");
        signature.setLocation("signer location");
        signature.setReason("reason for signature");
        signature.setSignDate(Calendar.getInstance());
        if (this.options == null) {
            doc.addSignature(signature, (SignatureInterface)this);
        } else {
            doc.addSignature(signature, (SignatureInterface)this, this.options);
        }
        doc.saveIncremental(fis, (OutputStream)fos);
        return outputDocument;
    }

    public byte[] sign(InputStream content) throws SignatureException, IOException {
        CMSProcessableInputStream input = new CMSProcessableInputStream(content);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        List<Certificate> certList = Arrays.asList(this.cert);
        CertStore certStore = null;
        try {
            certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), (Provider)provider);
            gen.addSigner(this.privKey, (X509Certificate)certList.get(0), CMSSignedGenerator.DIGEST_SHA256);
            gen.addCertificatesAndCRLs(certStore);
            CMSSignedData signedData = gen.generate((CMSProcessable)input, false, (Provider)provider);
            return signedData.getEncoded();
        }
        catch (Exception e) {
            System.err.println("Error while creating pkcs7 signature.");
            e.printStackTrace();
            throw new RuntimeException("Problem while preparing signature");
        }
    }

    public static void main(String[] args) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, COSVisitorException, SignatureException {
        if (args.length != 3) {
            CreateSignature.usage();
            System.exit(1);
        } else {
            File ksFile = new File(args[0]);
            KeyStore keystore = KeyStore.getInstance("PKCS12", (Provider)provider);
            char[] pin = args[1].toCharArray();
            keystore.load(new FileInputStream(ksFile), pin);
            File document = new File(args[2]);
            CreateSignature signing = new CreateSignature(keystore, (char[])pin.clone());
            signing.signPDF(document);
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateSignature.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf>");
    }
}

