/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public class AddImageToPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFromImage(String inputFile, String image, String outputFile) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load((String)inputFile);
            PDPage page = (PDPage)doc.getDocumentCatalog().getAllPages().get(0);
            PDJpeg ximage = null;
            if (image.toLowerCase().endsWith(".jpg")) {
                ximage = new PDJpeg(doc, (InputStream)new FileInputStream(image));
            } else if (image.toLowerCase().endsWith(".tif") || image.toLowerCase().endsWith(".tiff")) {
                ximage = new PDCcitt(doc, (RandomAccess)new RandomAccessFile(new File(image), "r"));
            } else {
                BufferedImage awtImage = ImageIO.read(new File(image));
                ximage = new PDPixelMap(doc, awtImage);
            }
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
            float scale = 1.0f;
            contentStream.drawXObject((PDXObject)ximage, 20.0f, 20.0f, (float)ximage.getWidth() * scale, (float)ximage.getHeight() * scale);
            contentStream.close();
            doc.save(outputFile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        AddImageToPDF app = new AddImageToPDF();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.createPDFFromImage(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-pdf> <image> <output-pdf>");
    }
}

