/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;

public class PrintImageLocations
extends PDFStreamEngine {
    private static final String INVOKE_OPERATOR = "Do";

    public PrintImageLocations() throws IOException {
        super(ResourceLoader.loadProperties((String)"org/apache/pdfbox/resources/PDFTextStripper.properties", (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintImageLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((String)args[0]);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintImageLocations printer = new PrintImageLocations();
                List allPages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDPage page = (PDPage)allPages.get(i);
                    System.out.println("Processing page: " + i);
                    printer.processStream(page, page.findResources(), page.getContents().getStream());
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        String operation = operator.getOperation();
        if (INVOKE_OPERATOR.equals(operation)) {
            COSName objectName = (COSName)arguments.get(0);
            Map xobjects = this.getResources().getXObjects();
            PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
            if (xobject instanceof PDXObjectImage) {
                PDXObjectImage image = (PDXObjectImage)xobject;
                PDPage page = this.getCurrentPage();
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                double pageHeight = page.getMediaBox().getHeight();
                System.out.println("*******************************************************************");
                System.out.println("Found image [" + objectName.getName() + "]");
                Matrix ctmNew = this.getGraphicsState().getCurrentTransformationMatrix();
                float yScaling = ctmNew.getYScale();
                float angle = (float)Math.acos(ctmNew.getValue(0, 0) / ctmNew.getXScale());
                if (ctmNew.getValue(0, 1) < 0.0f && ctmNew.getValue(1, 0) > 0.0f) {
                    angle = -1.0f * angle;
                }
                ctmNew.setValue(2, 1, (float)(pageHeight - (double)ctmNew.getYPosition() - Math.cos(angle) * (double)yScaling));
                ctmNew.setValue(2, 0, (float)((double)ctmNew.getXPosition() - Math.sin(angle) * (double)yScaling));
                ctmNew.setValue(0, 1, -1.0f * ctmNew.getValue(0, 1));
                ctmNew.setValue(1, 0, -1.0f * ctmNew.getValue(1, 0));
                AffineTransform ctmAT = ctmNew.createAffineTransform();
                ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
                float imageXScale = ctmNew.getXScale();
                float imageYScale = ctmNew.getYScale();
                System.out.println("position = " + ctmNew.getXPosition() + ", " + ctmNew.getYPosition());
                System.out.println("size = " + imageWidth + "px, " + imageHeight + "px");
                System.out.println("size = " + imageXScale + ", " + imageYScale);
                System.out.println("size = " + (imageXScale /= 72.0f) + "in, " + (imageYScale /= 72.0f) + "in");
                imageXScale = (float)((double)imageXScale * 25.4);
                imageYScale = (float)((double)imageYScale * 25.4);
                System.out.println("size = " + imageXScale + "mm, " + imageYScale + "mm");
                System.out.println();
            } else if (xobject instanceof PDXObjectForm) {
                Matrix matrix;
                this.getGraphicsStack().push((PDGraphicsState)this.getGraphicsState().clone());
                PDPage page = this.getCurrentPage();
                PDXObjectForm form = (PDXObjectForm)xobject;
                COSStream invoke = (COSStream)form.getCOSObject();
                PDResources pdResources = form.getResources();
                if (pdResources == null) {
                    pdResources = page.findResources();
                }
                if ((matrix = form.getMatrix()) != null) {
                    Matrix xobjectCTM = matrix.multiply(this.getGraphicsState().getCurrentTransformationMatrix());
                    this.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
                }
                this.processSubStream(page, pdResources, invoke);
                this.setGraphicsState((PDGraphicsState)this.getGraphicsStack().pop());
            }
        } else {
            super.processOperator(operator, arguments);
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.PrintImageLocations <input-pdf>");
    }
}

