/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.maxent.GIS;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.tools.coref.resolver.ResolverUtils;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.TestSimilarityModel;
import opennlp.tools.coref.sim.TrainSimilarityModel;
import opennlp.tools.util.CollectionEventStream;
import opennlp.tools.util.HashList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityModel
implements TestSimilarityModel,
TrainSimilarityModel {
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private int SAME_INDEX;
    private static final String SAME = "same";
    private static final String DIFF = "diff";
    private boolean debugOn = false;

    public static TestSimilarityModel testModel(String name) throws IOException {
        return new SimilarityModel(name, false);
    }

    public static TrainSimilarityModel trainModel(String name) throws IOException {
        SimilarityModel sm = new SimilarityModel(name, true);
        return sm;
    }

    private SimilarityModel(String modelName, boolean train) throws IOException {
        this.modelName = modelName;
        if (train) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(modelName + this.modelExtension)).getModel();
            this.SAME_INDEX = this.testModel.getIndex(SAME);
        }
    }

    private void addEvent(boolean same, Context np1, Context np2) {
        if (same) {
            List<String> feats = this.getFeatures(np1, np2);
            this.events.add(new Event(SAME, feats.toArray(new String[feats.size()])));
        } else {
            List<String> feats = this.getFeatures(np1, np2);
            this.events.add(new Event(DIFF, feats.toArray(new String[feats.size()])));
        }
    }

    private Set<String> constructHeadSet(List<Context> mentions) {
        HashSet<String> headSet = new HashSet<String>();
        for (Context ec : mentions) {
            headSet.add(ec.getHeadTokenText().toLowerCase());
        }
        return headSet;
    }

    private boolean hasSameHead(Set<String> entityHeadSet, Set<String> candidateHeadSet) {
        Iterator<String> hi = entityHeadSet.iterator();
        while (hi.hasNext()) {
            if (!candidateHeadSet.contains(hi.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameNameType(Set<String> entityNameSet, Set<String> candidateNameSet) {
        Iterator<String> hi = entityNameSet.iterator();
        while (hi.hasNext()) {
            if (!candidateNameSet.contains(hi.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSuperClass(List<Context> entityContexts, List<Context> candidateContexts) {
        for (Context ec : entityContexts) {
            Iterator<Context> cei = candidateContexts.iterator();
            while (cei.hasNext()) {
                if (!this.inSuperClass(ec, cei.next())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Context> constructExclusionSet(Integer entityKey, HashList entities, Map<Integer, Set<String>> headSets, Map<Integer, Set<String>> nameSets, List<Context> singletons) {
        HashSet<Context> exclusionSet = new HashSet<Context>();
        Set<String> entityHeadSet = headSets.get(entityKey);
        Set<String> entityNameSet = nameSets.get(entityKey);
        List entityContexts = (List)entities.get(entityKey);
        for (Integer key : entities.keySet()) {
            List candidateContexts = (List)entities.get(key);
            if (key.equals(entityKey)) {
                exclusionSet.addAll(candidateContexts);
                continue;
            }
            if (nameSets.get(key).isEmpty()) {
                exclusionSet.addAll(candidateContexts);
                continue;
            }
            if (this.hasSameHead(entityHeadSet, headSets.get(key))) {
                exclusionSet.addAll(candidateContexts);
                continue;
            }
            if (this.hasSameNameType(entityNameSet, nameSets.get(key))) {
                exclusionSet.addAll(candidateContexts);
                continue;
            }
            if (!this.hasSuperClass(entityContexts, candidateContexts)) continue;
            exclusionSet.addAll(candidateContexts);
        }
        ArrayList<Context> singles = new ArrayList<Context>(1);
        for (Context sc : singletons) {
            singles.clear();
            singles.add(sc);
            if (entityHeadSet.contains(sc.getHeadTokenText().toLowerCase())) {
                exclusionSet.add(sc);
                continue;
            }
            if (sc.getNameType() == null) {
                exclusionSet.add(sc);
                continue;
            }
            if (entityNameSet.contains(sc.getNameType())) {
                exclusionSet.add(sc);
                continue;
            }
            if (!this.hasSuperClass(entityContexts, singles)) continue;
            exclusionSet.add(sc);
        }
        return exclusionSet;
    }

    private Map<Integer, Set<String>> constructHeadSets(HashList entities) {
        HashMap<Integer, Set<String>> headSets = new HashMap<Integer, Set<String>>();
        for (Integer key : entities.keySet()) {
            List entityContexts = (List)entities.get(key);
            headSets.put(key, this.constructHeadSet(entityContexts));
        }
        return headSets;
    }

    private Set<String> constructNameSet(List<Context> mentions) {
        HashSet<String> nameSet = new HashSet<String>();
        for (Context ec : mentions) {
            if (ec.getNameType() == null) continue;
            nameSet.add(ec.getNameType());
        }
        return nameSet;
    }

    private Map<Integer, Set<String>> constructNameSets(HashList entities) {
        HashMap<Integer, Set<String>> nameSets = new HashMap<Integer, Set<String>>();
        for (Integer key : entities.keySet()) {
            List entityContexts = (List)entities.get(key);
            nameSets.put(key, this.constructNameSet(entityContexts));
        }
        return nameSets;
    }

    private boolean inSuperClass(Context ec, Context cec) {
        if (ec.getSynsets().size() == 0 || cec.getSynsets().size() == 0) {
            return false;
        }
        int numCommonSynsets = 0;
        for (String synset : ec.getSynsets()) {
            if (!cec.getSynsets().contains(synset)) continue;
            ++numCommonSynsets;
        }
        if (numCommonSynsets == 0) {
            return false;
        }
        return numCommonSynsets == ec.getSynsets().size() || numCommonSynsets == cec.getSynsets().size();
    }

    @Override
    public void setExtents(Context[] extentContexts) {
        HashList entities = new HashList();
        ArrayList<Context> singletons = new ArrayList<Context>();
        ArrayList<Context> allExtents = new ArrayList<Context>();
        for (Context ec : extentContexts) {
            if (ec.getId() == -1) {
                singletons.add(ec);
            } else {
                entities.put((Object)ec.getId(), ec);
            }
            allExtents.add(ec);
        }
        int axi = 0;
        Map<Integer, Set<String>> headSets = this.constructHeadSets(entities);
        Map<Integer, Set<String>> nameSets = this.constructNameSets(entities);
        for (Integer key : entities.keySet()) {
            Set<String> entityNameSet = nameSets.get(key);
            if (entityNameSet.isEmpty()) continue;
            List entityContexts = (List)entities.get(key);
            Set<Context> exclusionSet = this.constructExclusionSet(key, entities, headSets, nameSets, singletons);
            if (entityContexts.size() == 1) {
                // empty if block
            }
            int xl = entityContexts.size();
            for (int xi1 = 0; xi1 < xl; ++xi1) {
                Context ec1 = (Context)entityContexts.get(xi1);
                block3: for (int xi2 = xi1 + 1; xi2 < xl; ++xi2) {
                    Context ec2 = (Context)entityContexts.get(xi2);
                    this.addEvent(true, ec1, ec2);
                    int startIndex = axi;
                    do {
                        Context sec1 = (Context)allExtents.get(axi);
                        axi = (axi + 1) % allExtents.size();
                        if (exclusionSet.contains(sec1)) continue;
                        if (this.debugOn) {
                            System.err.println(ec1.toString() + " " + entityNameSet + " " + sec1.toString() + " " + nameSets.get(sec1.getId()));
                        }
                        this.addEvent(false, ec1, sec1);
                        continue block3;
                    } while (axi != startIndex);
                }
            }
        }
    }

    @Override
    public double compatible(Context mention1, Context mention2) {
        List<String> feats = this.getFeatures(mention1, mention2);
        if (this.debugOn) {
            System.err.println("SimilarityModel.compatible: feats=" + feats);
        }
        return this.testModel.eval(feats.toArray(new String[feats.size()]))[this.SAME_INDEX];
    }

    @Override
    public void trainModel() throws IOException {
        if (this.debugOn) {
            FileWriter writer = new FileWriter(this.modelName + ".events");
            for (Event e : this.events) {
                writer.write(e.toString() + "\n");
            }
            writer.close();
        }
        new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + this.modelExtension)).persist();
    }

    private boolean isName(Context np) {
        return np.getHeadTokenTag().startsWith("NNP");
    }

    private boolean isCommonNoun(Context np) {
        return !np.getHeadTokenTag().startsWith("NNP") && np.getHeadTokenTag().startsWith("NN");
    }

    private boolean isPronoun(Context np) {
        return np.getHeadTokenTag().startsWith("PRP");
    }

    private boolean isNumber(Context np) {
        return np.getHeadTokenTag().equals("CD");
    }

    private List<String> getNameCommonFeatures(Context name, Context common) {
        Set<String> synsets = common.getSynsets();
        ArrayList<String> features = new ArrayList<String>(2 + synsets.size());
        features.add("nn=" + name.getNameType() + "," + common.getNameType());
        features.add("nw=" + name.getNameType() + "," + common.getHeadTokenText().toLowerCase());
        Iterator<String> si = synsets.iterator();
        while (si.hasNext()) {
            features.add("ns=" + name.getNameType() + "," + si.next());
        }
        if (name.getNameType() == null) {
            // empty if block
        }
        return features;
    }

    private List<String> getNameNumberFeatures(Context name, Context number) {
        ArrayList<String> features = new ArrayList<String>(2);
        features.add("nt=" + name.getNameType() + "," + number.getHeadTokenTag());
        features.add("nn=" + name.getNameType() + "," + number.getNameType());
        return features;
    }

    private List<String> getNamePronounFeatures(Context name, Context pronoun) {
        ArrayList<String> features = new ArrayList<String>(2);
        features.add("nw=" + name.getNameType() + "," + pronoun.getHeadTokenText().toLowerCase());
        features.add("ng=" + name.getNameType() + "," + ResolverUtils.getPronounGender(pronoun.getHeadTokenText().toLowerCase()));
        return features;
    }

    private List<String> getCommonPronounFeatures(Context common, Context pronoun) {
        ArrayList<String> features = new ArrayList<String>();
        Set<String> synsets1 = common.getSynsets();
        String p = pronoun.getHeadTokenText().toLowerCase();
        String gen = ResolverUtils.getPronounGender(p);
        features.add("wn=" + p + "," + common.getNameType());
        for (String synset : synsets1) {
            features.add("ws=" + p + "," + synset);
            features.add("gs=" + gen + "," + synset);
        }
        return features;
    }

    private List<String> getCommonNumberFeatures(Context common, Context number) {
        ArrayList<String> features = new ArrayList<String>();
        Set<String> synsets1 = common.getSynsets();
        for (String synset : synsets1) {
            features.add("ts=" + number.getHeadTokenTag() + "," + synset);
            features.add("ns=" + number.getNameType() + "," + synset);
        }
        features.add("nn=" + number.getNameType() + "," + common.getNameType());
        return features;
    }

    private List<String> getNumberPronounFeatures(Context number, Context pronoun) {
        ArrayList<String> features = new ArrayList<String>();
        String p = pronoun.getHeadTokenText().toLowerCase();
        String gen = ResolverUtils.getPronounGender(p);
        features.add("wt=" + p + "," + number.getHeadTokenTag());
        features.add("wn=" + p + "," + number.getNameType());
        features.add("wt=" + gen + "," + number.getHeadTokenTag());
        features.add("wn=" + gen + "," + number.getNameType());
        return features;
    }

    private List<String> getNameNameFeatures(Context name1, Context name2) {
        ArrayList<String> features = new ArrayList<String>(1);
        if (name1.getNameType() == null && name2.getNameType() == null) {
            features.add("nn=" + name1.getNameType() + "," + name2.getNameType());
        } else if (name1.getNameType() == null) {
            features.add("nn=" + name1.getNameType() + "," + name2.getNameType());
        } else if (name2.getNameType() == null) {
            features.add("nn=" + name2.getNameType() + "," + name1.getNameType());
        } else {
            if (name1.getNameType().compareTo(name2.getNameType()) < 0) {
                features.add("nn=" + name1.getNameType() + "," + name2.getNameType());
            } else {
                features.add("nn=" + name2.getNameType() + "," + name1.getNameType());
            }
            if (name1.getNameType().equals(name2.getNameType())) {
                features.add("sameNameType");
            }
        }
        return features;
    }

    private List<String> getCommonCommonFeatures(Context common1, Context common2) {
        ArrayList<String> features = new ArrayList<String>();
        Set<String> synsets1 = common1.getSynsets();
        Set<String> synsets2 = common2.getSynsets();
        if (synsets1.size() == 0) {
            return features;
        }
        if (synsets2.size() == 0) {
            return features;
        }
        int numCommonSynsets = 0;
        for (String synset : synsets1) {
            if (!synsets2.contains(synset)) continue;
            features.add("ss=" + synset);
            ++numCommonSynsets;
        }
        if (numCommonSynsets == 0) {
            features.add("ncss");
        } else if (numCommonSynsets == synsets1.size() && numCommonSynsets == synsets2.size()) {
            features.add("samess");
        } else if (numCommonSynsets == synsets1.size()) {
            features.add("2isa1");
        } else if (numCommonSynsets == synsets2.size()) {
            features.add("1isa2");
        }
        return features;
    }

    private List<String> getPronounPronounFeatures(Context pronoun1, Context pronoun2) {
        String g2;
        ArrayList<String> features = new ArrayList<String>();
        String g1 = ResolverUtils.getPronounGender(pronoun1.getHeadTokenText());
        if (g1.equals(g2 = ResolverUtils.getPronounGender(pronoun2.getHeadTokenText()))) {
            features.add("sameGender");
        } else {
            features.add("diffGender");
        }
        return features;
    }

    private List<String> getFeatures(Context np1, Context np2) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("default");
        String w1 = np1.getHeadTokenText().toLowerCase();
        String w2 = np2.getHeadTokenText().toLowerCase();
        if (w1.compareTo(w2) < 0) {
            features.add("ww=" + w1 + "," + w2);
        } else {
            features.add("ww=" + w2 + "," + w1);
        }
        if (w1.equals(w2)) {
            features.add("sameHead");
        }
        if (this.isName(np1)) {
            if (this.isName(np2)) {
                features.addAll(this.getNameNameFeatures(np1, np2));
            } else if (this.isCommonNoun(np2)) {
                features.addAll(this.getNameCommonFeatures(np1, np2));
            } else if (this.isPronoun(np2)) {
                features.addAll(this.getNamePronounFeatures(np1, np2));
            } else if (this.isNumber(np2)) {
                features.addAll(this.getNameNumberFeatures(np1, np2));
            }
        } else if (this.isCommonNoun(np1)) {
            if (this.isName(np2)) {
                features.addAll(this.getNameCommonFeatures(np2, np1));
            } else if (this.isCommonNoun(np2)) {
                features.addAll(this.getCommonCommonFeatures(np1, np2));
            } else if (this.isPronoun(np2)) {
                features.addAll(this.getCommonPronounFeatures(np1, np2));
            } else if (this.isNumber(np2)) {
                features.addAll(this.getCommonNumberFeatures(np1, np2));
            }
        } else if (this.isPronoun(np1)) {
            if (this.isName(np2)) {
                features.addAll(this.getNamePronounFeatures(np2, np1));
            } else if (this.isCommonNoun(np2)) {
                features.addAll(this.getCommonPronounFeatures(np2, np1));
            } else if (this.isPronoun(np2)) {
                features.addAll(this.getPronounPronounFeatures(np1, np2));
            } else if (this.isNumber(np2)) {
                features.addAll(this.getNumberPronounFeatures(np2, np1));
            }
        } else if (this.isNumber(np1)) {
            if (this.isName(np2)) {
                features.addAll(this.getNameNumberFeatures(np2, np1));
            } else if (this.isCommonNoun(np2)) {
                features.addAll(this.getCommonNumberFeatures(np2, np1));
            } else if (this.isPronoun(np2)) {
                features.addAll(this.getNumberPronounFeatures(np1, np2));
            } else if (this.isNumber(np2)) {
                // empty if block
            }
        }
        return features;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: SimilarityModel modelName < tiger/NN bear/NN");
            System.exit(1);
        }
        String modelName = args[0];
        SimilarityModel model = new SimilarityModel(modelName, false);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (line != null) {
            String[] words = line.split(" ");
            double p = model.compatible(Context.parseContext(words[0]), Context.parseContext(words[1]));
            System.out.println(p + " " + model.getFeatures(Context.parseContext(words[0]), Context.parseContext(words[1])));
            line = in.readLine();
        }
    }
}

