/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaultsImpl;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.MultiColumnVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.SubclassJoinDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.ValueMapDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.meta.FieldMetaData;
import serp.util.Strings;

public class PersistenceMappingDefaults
extends MappingDefaultsImpl {
    private boolean _prependFieldNameToJoinTableInverseJoinColumns = true;

    public PersistenceMappingDefaults() {
        this.setDefaultMissingInfo(true);
        this.setStoreEnumOrdinal(true);
        this.setOrderLists(false);
        this.setAddNullIndicator(false);
        this.setDiscriminatorColumnName("DTYPE");
    }

    public boolean getPrependFieldNameToJoinTableInverseJoinColumns() {
        return this._prependFieldNameToJoinTableInverseJoinColumns;
    }

    public void setPrependFieldNameToJoinTableInverseJoinColumns(boolean val) {
        this._prependFieldNameToJoinTableInverseJoinColumns = val;
    }

    public Object getStrategy(Version vers, boolean adapt) {
        Object strat = super.getStrategy(vers, adapt);
        ClassMapping cls = vers.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || cls.getVersionField() != null) {
            return strat;
        }
        int nColumn = vers.getMappingInfo().getColumns().size();
        switch (nColumn) {
            case 0: {
                return NoneVersionStrategy.getInstance();
            }
            case 1: {
                return new NumberVersionStrategy();
            }
        }
        return new MultiColumnVersionStrategy();
    }

    public Object getStrategy(Discriminator disc, boolean adapt) {
        Object strat = super.getStrategy(disc, adapt);
        ClassMapping cls = disc.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || disc.getMappingInfo().getValue() != null) {
            return strat;
        }
        if (!disc.getMappingInfo().getColumns().isEmpty()) {
            return new ValueMapDiscriminatorStrategy();
        }
        ClassMapping base = cls;
        while (base.getMappingInfo().getHierarchyStrategy() == null && base.getPCSuperclassMapping() != null) {
            base = base.getPCSuperclassMapping();
        }
        strat = base.getMappingInfo().getHierarchyStrategy();
        if ("flat".equals(strat)) {
            return new ValueMapDiscriminatorStrategy();
        }
        if ("vertical".equals(strat) && this.dict.joinSyntax != 1) {
            return new SubclassJoinDiscriminatorStrategy();
        }
        return NoneDiscriminatorStrategy.getInstance();
    }

    public String getTableName(ClassMapping cls, Schema schema) {
        if (cls.getTypeAlias() != null) {
            return cls.getTypeAlias();
        }
        return Strings.getClassName(cls.getDescribedType()).replace('$', '_');
    }

    public String getTableName(FieldMapping fm, Schema schema) {
        ClassMapping clm = fm.getDefiningMapping();
        Table table = this.getTable(clm);
        String name = table.getName();
        ClassMapping rel = fm.getElementMapping().getTypeMapping();
        boolean assoc = rel != null && rel.getTable() != null && fm.getTypeCode() != 13;
        String name2 = null;
        name2 = assoc ? rel.getTable().getName() : fm.getName();
        name = this.dict.combineNames(name, name2);
        return name.replace('$', '_');
    }

    private Table getTable(ClassMapping clm) {
        Table table = clm.getTable();
        if (table == null) {
            ValueMappingImpl value = (ValueMappingImpl)clm.getEmbeddingMetaData();
            if (value == null) {
                return table;
            }
            FieldMetaData field = value.getFieldMetaData();
            clm = (ClassMapping)field.getDefiningMetaData();
            return this.getTable(clm);
        }
        return table;
    }

    public void populateJoinColumn(FieldMapping fm, Table local, Table foreign, Column col, Object target, int pos, int cols) {
        if (!(target instanceof Column)) {
            return;
        }
        FieldMapping[] inverses = fm.getInverseMappings();
        String name = inverses.length > 0 ? inverses[0].getName() : fm.getDefiningMapping().getTypeAlias();
        String targetName = ((Column)target).getName();
        String tempName = null;
        if (name.length() + targetName.length() >= this.dict.maxColumnNameLength) {
            tempName = name.substring(0, this.dict.maxColumnNameLength - targetName.length() - 1);
        }
        if (tempName == null) {
            tempName = name;
        }
        name = this.dict.combineNames(tempName, targetName);
        name = this.dict.getValidColumnName(name, foreign);
        col.setName(name);
    }

    public void populateForeignKeyColumn(ValueMapping vm, String name, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        boolean elem;
        boolean bl = elem = vm == vm.getFieldMapping().getElement() && vm.getFieldMapping().getTypeCode() != 13;
        if (!this._prependFieldNameToJoinTableInverseJoinColumns && !inverse && elem) {
            return;
        }
        if (target instanceof Column) {
            if (name == null) {
                name = col.getName();
            } else {
                if (elem) {
                    name = vm.getFieldMapping().getName();
                }
                if (this.isRemoveHungarianNotation()) {
                    name = this.removeHungarianNotation(name);
                }
                name = this.dict.combineNames(name, ((Column)target).getName());
                name = this.dict.getValidColumnName(name, local, false);
            }
            col.setName(name);
        }
    }

    public void populateColumns(Version vers, Table table, Column[] cols) {
        FieldMapping fm = vers.getClassMapping().getVersionFieldMapping();
        if (fm != null && cols.length == 1) {
            cols[0].setName(fm.getName());
        } else {
            super.populateColumns(vers, table, cols);
        }
    }
}

