/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.openjpa.event.DeleteListener;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.event.LoadListener;
import org.apache.openjpa.event.PersistListener;
import org.apache.openjpa.event.PostDeleteListener;
import org.apache.openjpa.event.PostPersistListener;
import org.apache.openjpa.event.UpdateListener;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.CallbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceListenerAdapter
implements LifecycleEventManager.ListenerAdapter,
PersistListener,
PostPersistListener,
LoadListener,
UpdateListener,
DeleteListener,
PostDeleteListener {
    private static final Localizer _loc = Localizer.forPackage(PersistenceListenerAdapter.class);
    private final LifecycleCallbacks[][] _callbacks;

    public PersistenceListenerAdapter(LifecycleCallbacks[][] callbacks) {
        this._callbacks = callbacks;
    }

    public PersistenceListenerAdapter(Collection<LifecycleCallbacks>[] calls) {
        this._callbacks = new LifecycleCallbacks[LifecycleEvent.ALL_EVENTS.length][];
        for (int i = 0; i < LifecycleEvent.ALL_EVENTS.length; ++i) {
            if (calls[i] == null) continue;
            this._callbacks[i] = calls[i].toArray(new LifecycleCallbacks[calls[i].size()]);
        }
    }

    @Override
    public boolean respondsTo(int eventType) {
        return this._callbacks[eventType] != null;
    }

    private void makeCallback(LifecycleEvent ev) {
        int eventType = ev.getType();
        if (this._callbacks[eventType] == null) {
            return;
        }
        Object src = ev.getSource();
        for (LifecycleCallbacks callback : this._callbacks[eventType]) {
            try {
                callback.makeCallback(src, ev.getRelated(), eventType);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new CallbackException(_loc.get("system-listener-err", src)).setCause(t).setFatal(true);
            }
        }
    }

    @Override
    public void beforePersist(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void afterPersist(LifecycleEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterPersistPerformed(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void afterLoad(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void afterRefresh(LifecycleEvent event) {
    }

    @Override
    public void beforeUpdate(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void afterUpdatePerformed(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void beforeDelete(LifecycleEvent event) {
        this.makeCallback(event);
    }

    @Override
    public void afterDelete(LifecycleEvent event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterDeletePerformed(LifecycleEvent event) {
        this.makeCallback(event);
    }
}

