/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecoratingDataSource
extends DelegatingDataSource {
    private static final Constructor<DecoratingDataSource> implClass;
    private List<ConnectionDecorator> _decorators = new CopyOnWriteArrayList<ConnectionDecorator>();

    public DecoratingDataSource(DataSource ds) {
        super(ds);
    }

    public static DecoratingDataSource newDecoratingDataSource(DataSource ds) {
        return ConcreteClassGenerator.newInstance(implClass, ds);
    }

    public Collection<ConnectionDecorator> getDecorators() {
        return Collections.unmodifiableCollection(this._decorators);
    }

    public void addDecorator(ConnectionDecorator decorator) {
        if (decorator != null) {
            this._decorators.add(decorator);
        }
    }

    public void addDecorators(Collection<ConnectionDecorator> decorators) {
        if (decorators != null) {
            this._decorators.addAll(decorators);
        }
    }

    public boolean removeDecorator(ConnectionDecorator decorator) {
        return this._decorators.remove(decorator);
    }

    public void clearDecorators() {
        this._decorators.clear();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = super.getConnection();
        return this.decorate(conn);
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        Connection conn = super.getConnection(user, pass);
        return this.decorate(conn);
    }

    private Connection decorate(Connection conn) throws SQLException {
        for (ConnectionDecorator decorator : this._decorators) {
            conn = decorator.decorate(conn);
        }
        return conn;
    }

    static {
        try {
            implClass = ConcreteClassGenerator.getConcreteConstructor(DecoratingDataSource.class, DataSource.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

