/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.PessimisticLockManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OptimisticException;

public class MixedLockManager
extends PessimisticLockManager {
    private static final Localizer _loc = Localizer.forPackage(MixedLockManager.class);

    public boolean selectForUpdate(Select sel, int lockLevel) {
        return lockLevel >= 30 ? super.selectForUpdate(sel, lockLevel) : false;
    }

    protected void lockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        if (level >= 50) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(true);
            super.lockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        } else if (level >= 30) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(false);
            super.lockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        } else if (level >= 10) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(true);
            this.optimisticLockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        }
    }

    protected void optimisticLockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        super.optimisticLockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        if (postLockVersionCheck && level >= 30) {
            ClassMapping mapping = (ClassMapping)sm.getMetaData();
            try {
                if (!mapping.getVersion().checkVersion(sm, this.getStore(), false)) {
                    throw new OptimisticException((Object)_loc.get("optimistic-violation-lock").getMessage()).setFailedObject(sm.getObjectId());
                }
            }
            catch (SQLException se) {
                throw SQLExceptions.getStore(se, sm.getObjectId(), this.getStore().getDBDictionary());
            }
        }
    }
}

