/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.Server;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class AdminDaemon
implements ServerService {
    public void init(Properties props) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void service(Socket socket) throws ServiceException, IOException {
        InputStream in = null;
        try {
            in = socket.getInputStream();
            byte requestTypeByte = (byte)in.read();
            try {
                RequestType requestType = RequestType.valueOf((byte)requestTypeByte);
                switch (requestType) {
                    case NOP_REQUEST: {
                        return;
                    }
                    case STOP_REQUEST_Quit: 
                    case STOP_REQUEST_quit: 
                    case STOP_REQUEST_Stop: 
                    case STOP_REQUEST_stop: {
                        Server server = (Server)SystemInstance.get().getComponent(Server.class);
                        if (null == server) return;
                        server.stop();
                        return;
                    }
                }
                Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, AdminDaemon.class).warning("Invalid Server Socket request: " + requestType);
                return;
            }
            catch (IllegalArgumentException iae) {
                Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, AdminDaemon.class).warning("Invalid Server Socket request: " + requestTypeByte);
                return;
            }
        }
        catch (Throwable e) {
            Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER, AdminDaemon.class).warning("Server Socket request failed", e);
            return;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    @Override
    public void start() throws ServiceException {
    }

    @Override
    public void stop() throws ServiceException {
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public String getIP() {
        return "";
    }

    @Override
    public String getName() {
        return "admin thread";
    }
}

