/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.core.TempClassLoader;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceBootstrap {
    private static final String defaultProvider = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    private static boolean debug;

    public static void bootstrap(ClassLoader classLoader) {
        Properties args = PersistenceBootstrap.getAgentArgs(classLoader);
        debug = args.getProperty("debug", "false").equalsIgnoreCase("true");
        boolean enabled = args.getProperty("enabled", "true").equalsIgnoreCase("true");
        if (!enabled) {
            PersistenceBootstrap.debug("disabled");
            return;
        }
        try {
            PersistenceBootstrap.debug("searching for persistence.xml files");
            ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF/persistence.xml"));
            if (urls.size() == 0) {
                PersistenceBootstrap.debug("no persistence.xml files found");
                return;
            }
            HashMap<String, Unit> units = new HashMap<String, Unit>();
            for (URL url : urls) {
                String urlPath = url.toExternalForm();
                PersistenceBootstrap.debug("found " + urlPath);
                try {
                    InputStream in = url.openStream();
                    try {
                        PersistenceBootstrap.collectUnits(in, units, args);
                    }
                    catch (Throwable e) {
                        PersistenceBootstrap.debug("failed to read " + urlPath, e);
                        in.close();
                    }
                }
                catch (Throwable e) {
                    PersistenceBootstrap.debug("failed to read " + urlPath, e);
                }
            }
            for (Unit unit : units.values()) {
                String provider = unit.provider;
                String extraClassesKey = provider + "@classes";
                String unitNameKey = provider + "@unitName";
                String unitName = args.getProperty(unitNameKey, "classpath-bootstrap");
                String classes = args.getProperty(extraClassesKey);
                if (classes != null) {
                    PersistenceBootstrap.debug("parsing value of " + extraClassesKey);
                    try {
                        List<String> list = Arrays.asList(classes.split("[ \n\r\t,]"));
                        unit.classes.addAll(list);
                    }
                    catch (Exception e) {
                        PersistenceBootstrap.debug("cannot parse: " + classes, e);
                    }
                }
                try {
                    if (provider.startsWith("org.hibernate")) {
                        PersistenceBootstrap.debug("skipping: " + provider);
                        continue;
                    }
                    PersistenceBootstrap.debug("starting: " + provider);
                    PersistenceUnitInfoImpl info = new PersistenceUnitInfoImpl(new Handler());
                    info.setManagedClassNames(new ArrayList<String>(unit.classes));
                    info.setPersistenceProviderClassName(unit.provider);
                    info.setProperties(new Properties());
                    info.setId(unitName);
                    info.setPersistenceUnitName(unitName);
                    info.setRootUrlAndJarUrls("", Collections.EMPTY_LIST);
                    info.setJtaDataSource(new NullDataSource());
                    info.setNonJtaDataSource(new NullDataSource());
                    info.setExcludeUnlistedClasses(true);
                    info.setClassLoader(classLoader);
                    for (String name : unit.classes) {
                        PersistenceBootstrap.debug("class " + name);
                    }
                    Class<?> clazz = classLoader.loadClass(unit.provider);
                    PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
                    EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory(info, new HashMap());
                    PersistenceBootstrap.debug("success: " + provider);
                }
                catch (Throwable e) {
                    PersistenceBootstrap.debug("failed: " + provider, e);
                }
            }
        }
        catch (Throwable t) {
            PersistenceBootstrap.debug("error: ", t);
        }
    }

    private static void debug(String x) {
        if (debug) {
            System.out.println("[PersistenceBootstrap] " + x);
        }
    }

    private static void debug(String x, Throwable t) {
        if (debug) {
            System.out.println(x);
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getAgentArgs(ClassLoader classLoader) {
        Properties properties;
        block8: {
            properties = new Properties();
            String args = Agent.getAgentArgs();
            if (args != null && args.length() != 0) {
                for (String string : args.split("[ ,:&]")) {
                    String[] strings = string.split("=");
                    if (strings == null || strings.length != 2) continue;
                    properties.put(strings[0], strings[1]);
                }
                debug = properties.getProperty("debug", "false").equalsIgnoreCase("true");
            }
            try {
                URL resource = classLoader.getResource("PersistenceBootstrap.properties");
                if (resource == null) break block8;
                PersistenceBootstrap.debug("found PersistenceBootstrap.properties file");
                InputStream in = resource.openStream();
                try {
                    properties.load(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable e) {
                PersistenceBootstrap.debug("can't read PersistenceBootstrap.properties file", e);
            }
        }
        return properties;
    }

    private static void collectUnits(InputStream in, final Map<String, Unit> units, final Properties args) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = new InputSource(in);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(inputSource, new DefaultHandler(){
            private StringBuilder characters = new StringBuilder();
            private Unit unit;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                this.characters = new StringBuilder(100);
                if (localName.equals("persistence-unit")) {
                    this.startPersistenceUnit(uri, localName, qName, attributes);
                }
            }

            public void startPersistenceUnit(String uri, String localName, String qName, Attributes attributes) {
                String unitName = attributes.getValue(null, "name");
                this.unit = new Unit(unitName);
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                String text = new String(ch, start, length);
                this.characters.append(text.trim());
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if (localName.equals("persistence-unit")) {
                    this.endPersistenceUnit(uri, localName, qName);
                } else if (localName.equals("provider")) {
                    this.endProvider(uri, localName, qName);
                } else if (localName.equals("class")) {
                    this.endClass(uri, localName, qName);
                }
            }

            public void endPersistenceUnit(String uri, String localName, String qName) {
                if (args.getProperty(this.unit.name + "@skip", "false").equalsIgnoreCase("true")) {
                    PersistenceBootstrap.debug("skipping unit " + this.unit.name);
                } else {
                    Unit u;
                    PersistenceBootstrap.debug("adding unit " + this.unit.name);
                    if (this.unit.provider == null) {
                        this.unit.provider = PersistenceBootstrap.defaultProvider;
                    }
                    if ((u = (Unit)units.get(this.unit.provider)) == null) {
                        units.put(this.unit.provider, this.unit);
                    } else {
                        u.classes.addAll(this.unit.classes);
                    }
                }
                this.unit = null;
            }

            public void endProvider(String uri, String localName, String qName) {
                this.unit.provider = this.characters.toString();
            }

            public void endClass(String uri, String localName, String qName) {
                this.unit.classes.add(this.characters.toString());
            }
        });
    }

    private static class NullDataSource
    implements DataSource {
        private NullDataSource() {
        }

        @Override
        public Connection getConnection() throws SQLException {
            return null;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return null;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLException();
        }
    }

    public static class Transformer
    implements ClassFileTransformer {
        private final ClassFileTransformer transformer;

        public Transformer(ClassFileTransformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                byte[] bytes = this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                if (bytes != null) {
                    PersistenceBootstrap.debug("enhanced " + className);
                }
                return bytes;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class Handler
    implements PersistenceClassLoaderHandler {
        private Handler() {
        }

        @Override
        public void addTransformer(String unitId, ClassLoader classLoader, ClassFileTransformer classFileTransformer) {
            Instrumentation instrumentation = Agent.getInstrumentation();
            if (instrumentation != null) {
                instrumentation.addTransformer(new Transformer(classFileTransformer));
            }
        }

        @Override
        public void destroy(String unitId) {
        }

        @Override
        public ClassLoader getNewTempClassLoader(ClassLoader classLoader) {
            return new TempClassLoader(classLoader);
        }
    }

    private static class Unit {
        private String provider;
        private final Set<String> classes = new HashSet<String>();
        private final String name;

        public Unit(String name) {
            this.name = name;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }
    }
}

